clear; clc; clf; hold on
E=[0.01 0.1:0.1:2.2]; t=0:0.1:20; T=length(t); % set domain
phi=0.001; %rotation angle for red/blue glasses
for n=1:length(E)
    x=t; y=E(n)*ones(1,T);
    % z=pendulum(t,E(n)); %initialized at top of trajectory
    z=pendulumshift(t,0,sqrt(2*E(n))); %shifts solution to theta0=0
    %rotation for 3D red/cyan plot
    A=[cos(phi) -sin(phi) 0; sin(phi) cos(phi) 0; 0 0 1];
    for j=1:T
        r=A*[x(j);y(j);z(j)]; xr(j)=r(1);yr(j)=r(2);zr(j)=r(3);
    end
    plot3(x,y,z,'r','linewidth',1')
    plot3(xr,yr,zr,'c','linewidth',1')
end
view(-34.470810813640462,29.972258042492722); axis tight
hAxis=gca; hAxis.YRuler.SecondCrossoverValue = 0;
hAxis.XRuler.SecondCrossoverValue = 0;
xlabel('$t\sqrt{\frac{g}{\ell}}$','fontsize',30,'interpreter','latex')
ylabel('$\frac{E}{mg\ell}$','fontsize',30,'interpreter','latex')
zlabel('$\theta$','fontsize',30,'interpreter','latex')
set(gca,'ztick',[0:pi:8*pi])
set(gca,'zticklabels',{'0','\pi','2\pi','3\pi','4\pi','5\pi','6\pi','7\pi','8\pi'})
function f=pendulumshift(t,theta0,omega0)
E=(omega0^2)/2+1-cos(theta0); s=sign(omega0);
%find initial condition along trajectory
tshift=fzero(@(t) pendulum(t,E,s)-theta0,-sign(omega0)*eps);
%shift to place the initial condition at t=0
f=pendulum(t-sign(2-E)*tshift,E,s);
end