clear;clc;clf
%NUMERICAL SOLUTION
dx=0.0001; %STEP SIZE
x=0:dx:5; %DOMAIN OF INDEPENDENT VARIABLE
%INITIAL CONDITION VECTOR (or value, if ODE is 1st-order)
yN(1)=0; %for plotting purposes, do nonderivative condition first separately
u=[yN(1) 0 1]; %this is u=[y(0) y'(0) etc] where in MATLAB y(0) is represented by yN(1)
%NUMERICAL SOLUTION (RK4 ENGINE)
for n=1:length(x)-1
    k1=F(u,x(n)) ; k2=F(u+k1*dx/2,x(n)+dx/2) ;
    k3=F(u+k2*dx/2,x(n)+dx/2) ; k4=F(u+k3*dx,x(n)+dx) ;
    u=u+(dx/6)*(k1+2*k2+2*k3+k4);
    yN(n+1)=u(1);
end; hold on
plot(x(1:1e3:end),yN(1:1e3:end),'k.','markersize',45,'displayname','Numerical (RK4)');
axis1=axis; hold on; ax = gca; ax.ColorOrderIndex = 1;
%POWER SERIES SOLUTION
N=160; %Number of terms to be taken in series
a=zeros(1,N);
a0=0; a(1)=(0); a(2)=1/2; a(3)=(4-a0)/6; a(4)=(1-a(1)-6*a(3))/24;
for n=(2):N-3
    sum1=0; sum2=cos(pi*n/2)/factorial(n)*a0; %j=n term
    for j=(0):n-1
        sum1=sum1+(j+1)*(j+2)*(j+3)*a(j+3)/factorial(n-j);
        sum2=sum2+cos(pi*j/2)/factorial(j)*a(n-j);
    end
    a(n+3)=-(sum1+sum2)/(n+1)/(n+2)/(n+3);
end
%Assembling Power Series
yS=a0;
for n=1:N
    yS=yS+a(n)*x.^n;
    %Plotting
    if n==10 || n==20 || n==40 || n==80 || n==160
        plot(x,yS,'--','linewidth',4,'displayname',[num2str(n) ' term series']);
        axis(axis1); hold on
    end
end
%Formatting Figures
legend('show','location','northwest','interpreter','latex','fontsize',30,'edgecolor','none')
ax=gca; ax.FontSize=30; ax.FontWeight='bold'; xlabel('$x$','fontsize',70,'interpreter','latex')
ylabel('$y$','fontsize',70,'interpreter','latex');
set(gcf,'units','centimeters','position',[0,0,30,30]);
axis square;
%RHS of ODE for Numerical Solution
function dddy = F(u,x)
y=u(1); dy=u(2); ddy=u(3);
dddy=[dy ddy (4+x-cos(x)*y)*exp(-x)];
end