clear;clc;clf; theta=0.04; %3D rotation angle for 3D glasses
dt=0.0001;T=10; t=0:dt:T; %time spacing and duration
%analytic solution
x=exp(-1/2*t).*(13*cos(13/2*t)+11*sin(13/2*t))/130; y=-exp(-1/2*t).*sin(13/2*t)/13;
z=1/340*exp(-2*t)+exp(-t).*(13*sin(13*t)+18*cos(13*t)-187)/57460;
%For 3D glasses
A=[cos(theta) -sin(theta) 0; sin(theta) cos(theta) 0; 0 0 1]; %rotation matrix
xr=x; yr=y; zr=z;
for n=1:length(x)
    r=A*[x(n);y(n);z(n)]; xr(n)=r(1);yr(n)=r(2);zr(n)=r(3);
end
plot3(x,y,z,'r','linewidth',2); hold on; plot3(xr,yr,zr,'c','linewidth',2); axis1=axis;
%power series solution
a0=.1; b0=0; c0=0;
N=90; %number of terms
a(1)=5*a0+29/2*b0; b(1)=-5*a0-6*b0; c(1)=a0*b0-2*c0;
for n=(1):N
    a(n+1)=(5*a(n)+29/2*b(n))/(n+1); b(n+1)=(-5*a(n)-6*b(n))/(n+1);
    csum=a0*b(n)+b0*a(n);
    for j=1:n-1, csum=csum+a(n-j)*b(j); end
    c(n+1)=(csum-2*c(n))/(n+1);
end
xs=a0; ys=b0; zs=c0;
for n=1:N
    xs=xs+a(n)*t.^n; ys=ys+b(n)*t.^n; zs=zs+c(n)*t.^n;
    if n==10 || n==30 || n==90
        plot3(xs,ys,zs,'r--','linewidth',1);
        for nn=1:length(x)
            r=A*[xs(nn);ys(nn);zs(nn)]; xsr(nn)=r(1);ysr(nn)=r(2);zsr(nn)=r(3);
        end; plot3(xsr,ysr,zsr,'c--','linewidth',1); axis(axis1)
    end
end
ax=gca; ax.FontSize=15; ax.FontWeight='bold'; xlabel('$x$','fontsize',40,'interpreter','latex')
ylabel('$y$','fontsize',40,'interpreter','latex'); zlabel('$z$','fontsize',40,'interpreter','latex')
view(213.52,16.38);