clear;clc;clf;
N=20; t=0:0.01:6;
subplot(2,1,1); plot(t,-pi+4*atan(exp(t)),'k','linewidth',2,'displayname','exact');
axis1=axis; hold on
theta0=0; omega0=2; a0=theta0;s0=sin(theta0); c0=cos(theta0);
a(1)=omega0; a(2)=-s0/2; s(1)=a(1)*c0; c(1)=-a(1)*s0;
for n=(1):N-2, ssum=(n+1)*a(n+1)*c0; csum=(n+1)*a(n+1)*s0;
    for k=(0):n-1
        ssum=ssum+(k+1)*a(k+1)*c(n-k); csum=csum+(k+1)*a(k+1)*s(n-k);
    end; s(n+1)=ssum/(n+1); c(n+1)=-csum/(n+1); a(n+2)=-s(n)/(n+1)/(n+2);
end; f=a0;
for n=1:N, f=f+a(n)*t.^n; %series solution
    if n==1 || n==7 || n==13 || n==19
        subplot(2,1,1);
        plot(t,f,'--','linewidth',2,'displayname',[num2str((n+1)/2) ' term series ']); axis(axis1);
    end
end
a=a(1:2:end); nv=[1:length(a)];
ratio_test=abs(a(1:end-1)./a(2:end));
root_test=(abs(a)).^(-1./nv);
R_ratio=(nv(2:end-1).*ratio_test(2:end)-nv(1:end-2).*ratio_test(1:end-1));
R_root=(nv(2:end).*root_test(2:end)-nv(1:end-1).*root_test(1:end-1));
subplot(2,1,2)
plot(1./nv(1:end-1),ratio_test,...
    'b.','markersize',30,'displayname',' $\left|\frac{\tilde{a}_n}{\tilde{a}_{n+1}}\right|$')
axis tight; xlim([0 1]); hold on
plot(1./nv,root_test,'k.','markersize',30,'displayname','$\left|\tilde{a}_n\right|^{-\frac{1}{n}}$')
plot(0,1.5669^2,'r.','markersize',30,'displayname','$R_{n=10}^2$')
subplot(2,1,1)
ax=gca; ax.FontSize=15; ax.FontWeight='bold';
legend('show','location','southeast','interpreter','latex','fontsize',20,'edgecolor','none')
ylabel('$\theta$','fontsize',40,'interpreter','latex');
xlabel('$\tilde{t}$','fontsize',40,'interpreter','latex');
subplot(2,1,2)
ax=gca; ax.FontSize=15; ax.FontWeight='bold';
legend('show','location','east','interpreter','latex','fontsize',20,'edgecolor','k')
xlabel('$1/n$','fontsize',40,'interpreter','latex');