clear;clc;clf
%INITIAL CONDITIONS & PARAMETERS
alpha=1; gamma=0; beta=0.5; kappa=0.927680039836653; B=-0.804548615; % for beta=0.5
%NUMERICAL SOLUTION (RK4)
deta=0.0001; eta=0:deta:8; fN=eta; fN(1)=0; F=[fN(1) gamma kappa];
for n=1:length(eta)-1
    k1=f(F,alpha,beta) ; k2=f(F+k1*deta/2,alpha,beta) ;
    k3=f(F+k2*deta/2,alpha,beta) ; k4=f(F+k3*deta,alpha,beta) ;
    F=F+(deta/6)*(k1+2*k2+2*k3+k4); fN(n+1)=F(1);
end; figure(1); subplot(1,2,1)
plot(eta(1:2*10^3:end),fN(1:2*10^3:end),'k.','markersize',20,'displayname','Numerical (RK4)');
axis1=axis; hold on; ax = gca; ax.ColorOrderIndex = 1; figure(2); subplot(1,2,1); hold on
plot(eta(1:2*10^3:end),fN(1:2*10^3:end),'k.','markersize',20,'displayname','Numerical (RK4)');
%POWER SERIES SOLUTION AND RESUMMATION
N=200;%Number of terms to be taken in series
a=zeros(1,N);at=a;A=a; a0=fN(1); at0=a0-B; A0=1/at0;
a(1)=gamma; a(2)=kappa/2; a(3)=(beta*(a(1)^2-1)-2*a0*a(2))/6/alpha; at(1)=a(1)-1;
at(2)=a(2); at(3)=a(3);
for n=1:N
    asum=beta*a(1)*(n+1)*a(n+1)-a(n)*2*a(2)+beta*(n+1)*a(n+1)*a(1)-a0*(n+1)*(n+2)*a(n+2);
    Asum=at(n)*A0;
    for j=1:n-1
        asum=asum+beta*(j+1)*a(j+1)*(n-j+1)*a(n-j+1)-a(n-j)*(j+1)*(j+2)*a(j+2);
        Asum=Asum+at(j)*A(n-j);
    end
    a(n+3)=asum/alpha/(n+1)/(n+2)/(n+3); at(n+3)=a(n+3); A(n)=-Asum/at0;
end
a=a(1:N); at=at(1:N);
%ASSEMBLING POWER SERIES AND RESUMMATION
fS=a0; fAsum=A0; m=0;
for n=1:N
    fS=fS+a(n)*eta.^n; fAsum=fAsum+A(n)*eta.^n;
    %PLOTTING
    if n==2 || n==10 || n==50, figure(1);
        subplot(1,2,1); plot(eta,fS,'--','linewidth',2,'displayname',[num2str(n) ' term series']);
        axis(axis1); hold on
    end
    if n==2 || n==10 || n==50
        figure(2); m=m+1; subplot(1,2,1); ax = gca; ax.ColorOrderIndex = m;
        plot(eta,fS,'--','linewidth',2,'displayname',[num2str(n) ' term series']);
        axis(axis1); hold on; ax = gca; ax.ColorOrderIndex = m;
        fA=eta+B+1./fAsum; plot(eta,fA,'linewidth',2,'displayname',[num2str(n) ' term resummation']);
        subplot(1,2,2); ax = gca; ax.ColorOrderIndex = m;
        semilogy(eta,abs(fS-fN),'--','linewidth',2,'displayname',[num2str(n) ' term series']);
        hold on; ax = gca; ax.ColorOrderIndex = m;
        semilogy(eta,abs(fA-fN),'linewidth',2,'displayname',[num2str(n) ' term resummation']);
    end
end
figure(1); subplot(1,2,2); plot([3:200],abs(a(3:end)).^(-1./[3:200]),'k','linewidth',2);% ROOT TEST
%FORMATTING FIGURES
figure(1); subplot(1,2,1)
legend('show','location','southeast','interpreter','latex','fontsize',12,'edgecolor','none')
ax=gca; ax.FontSize=15; ax.FontWeight='bold'; xlabel('$\eta$','fontsize',40,'interpreter','latex')
ylabel('$f$','fontsize',40,'interpreter','latex');
set(gcf,'units','centimeters','position',[0,0,30,30]); axis square; subplot(1,2,2); ax=gca;
ax.FontSize=15; ax.FontWeight='bold'; xlabel('$n$','fontsize',40,'interpreter','latex');
ylabel('$|a_n|^{-1/n}$','fontsize',40,'interpreter','latex');
set(gcf,'units','centimeters','position',[0,0,30,30]); axis square; axis tight;
figure(2); subplot(1,2,1)
legend('show','location','southeast','interpreter','latex','fontsize',10,'edgecolor','none');
ax=gca; ax.FontSize=15; ax.FontWeight='bold'; xlabel('$\eta$','fontsize',40,'interpreter','latex');
ylabel('$f$','fontsize',40,'interpreter','latex');
set(gcf,'units','centimeters','position',[0,0,30,30]); axis square; subplot(1,2,2); ax=gca;
ax.FontSize=15; ax.FontWeight='bold'; xlabel('$\eta$','fontsize',40,'interpreter','latex');
ylabel('error','fontsize',40,'interpreter','latex');
set(gcf,'units','centimeters','position',[0,0,30,30]);
ylim([1e-20 100]);axis square;
%RHS OF ODE FOR NUMERICAL SOLUTION
function dddF = f(F,alpha,beta)
dddF=[F(2) F(3) (-F(1)*F(3)-beta*(1-F(2)^2))/alpha];end