%%Budworm Example
clear;clc;clf; close all %INITIAL CONDITIONS & PARAMETERS (below)
x0=1;r=1;k=1;
%NUMERICAL SOLUTION (RK4)
dt=0.0001; t=0:dt:20; xN=t; xN(1)=x0;
for n=1:length(t)-1
    k1=f(xN(n),r,k); k2=f(xN(n)+k1*dt/2,r,k) ;
    k3=f(xN(n)+k2*dt/2,r,k); k4=f(xN(n)+k3*dt,r,k) ;
    xN(n+1)=xN(n)+(dt/6)*(k1+2*k2+2*k3+k4);
end; figure(1); subplot(1,2,1)
plot(t(1:10^3:end),xN(1:10^3:end),'k.','markersize',20,'displayname','Numerical (RK4)');
axis1=axis; hold on; ax = gca; ax.ColorOrderIndex = 1;
figure(2); subplot(1,2,1); hold on;
plot(t(1:10^3:end),xN(1:10^3:end),'k.','markersize',20,'displayname','Numerical (RK4)');
%POWER SERIES SOLUTION
N=500;%Number of terms to be taken in series
a0=x0; b0=a0^2; c0=b0/(1+b0); a(1)=r*a0-r/k*b0-c0;
for n=(1):N-1
    bsum=2*a0*a(n); %j=0 and j=n index in below
    for j=1:n-1, bsum=bsum+a(j)*a(n-j); end; b(n)=bsum;
    csum=c0*b(n); %j=n term in below
    for j=1:n-1, csum=csum+b(j)*c(n-j); end; c(n)=b(n)/(b0+1)-csum/(b0+1);
    a(n+1)=(r*a(n)-r/k*b(n)-c(n))/(n+1);
end; xS=a0; m=0;
for n=1:N %assembling and plotting
    xS=xS+a(n)*t.^n; %power series
    if n==2 || n==10 || n==18 || n==26 || n==34
        m=m+1;
        figure(1); subplot(1,2,1); ax = gca; ax.ColorOrderIndex = m;
        plot(t,xS,'--','linewidth',2,'displayname',[num2str(n) ' term series']);
        axis(axis1); hold on
        figure(2); subplot(1,2,1); ax = gca; ax.ColorOrderIndex = m;
        plot(t,xS,'--','linewidth',2,'displayname',[num2str(n) ' term series']);
        axis(axis1); hold on; ax.ColorOrderIndex = m;
        [A,B]=PadeApproximant(a0,a,n/2,n/2); xAn=a0; xAd=1;
        for j=1:n/2, xAn=xAn+A(j)*t.^j; xAd=xAd+B(j)*t.^j; end; xA=xAn./xAd;
        plot(t,xA,'linewidth',2,'displayname',...
            ['[' num2str(n/2) '/' num2str(n/2) '] approximant' ]);
        subplot(1,2,2); ax = gca; ax.ColorOrderIndex = m; semilogy(t,abs(xS-xN),'--','linewidth',2);
        hold on; ax = gca; ax.ColorOrderIndex = m; semilogy(t,abs(xA-xN),'linewidth',2);
    end
end
figure(1); subplot(1,2,2);plot(1./[1:N],abs(a).^(-1./[1:N]),'k','linewidth',2);% ROOT TEST
figure(1); subplot(1,2,1) %Formatting Figures
legend('show','location','northeast','interpreter','latex','fontsize',14,'edgecolor','none')
ax=gca; ax.FontSize=15; ax.FontWeight='bold'; xlabel('$t$','fontsize',40,'interpreter','latex')
ylabel('$x$','fontsize',40,'interpreter','latex');
set(gcf,'units','centimeters','position',[0,0,30,30]); axis square; xlim([0 4]); ylim([0.5 1])
subplot(1,2,2)
ax=gca; ax.FontSize=15; ax.FontWeight='bold'; xlabel('$1/n$','fontsize',40,'interpreter','latex')
ylabel('$|a_n|^{-1/n}$','fontsize',40,'interpreter','latex');
set(gcf,'units','centimeters','position',[0,0,30,30]); axis square; figure(2); subplot(1,2,1);
legend('show','location','northeast','interpreter','latex','fontsize',10,'edgecolor','none');
ax=gca; ax.FontSize=15; ax.FontWeight='bold'; xlabel('$t$','fontsize',40,'interpreter','latex');
ylabel('$x$','fontsize',40,'interpreter','latex');
set(gcf,'units','centimeters','position',[0,0,30,30]); axis square; ylim([0.3 1])
subplot(1,2,2); ax=gca;
ax.FontSize=15; ax.FontWeight='bold'; xlabel('$t$','fontsize',40,'interpreter','latex');
ylabel('error','fontsize',40,'interpreter','latex');
set(gcf,'units','centimeters','position',[0,0,30,30]);
ylim([1e-20 100]);axis square;
%RHS of ODE for Numerical Solution
function dx = f(x,r,k)
dx=r*x-r/k*x^2-x^2/(1+x^2);
end