clear;clc;clf; close all %INITIAL CONDITIONS & PARAMETERS (below)
S0=254; I0=7; alpha=2.73; r=0.0178; beta=alpha*log(S0)-r*(S0+I0);
syms Sinf; F=beta+r*Sinf-alpha*log(Sinf); Sinf=double(vpasolve(F,Sinf,0.1));
lambda=r*Sinf-alpha; % asymptotic exponential damping
dt=0.0001; t=0:dt:6; S=t; S(1)=S0;
for n=1:length(t)-1 %%NUMERICAL SOLUTION (RK4)
    k1=f(S(n),alpha,r,beta); k2=f(S(n)+k1*dt/2,alpha,r,beta) ;k3=f(S(n)+k2*dt/2,alpha,r,beta);
    k4=f(S(n)+k3*dt,alpha,r,beta) ; S(n+1)=S(n)+(dt/6)*(k1+2*k2+2*k3+k4);
end; figure(1); subplot(1,2,1)
plot(t(1:10^3:end),S(1:10^3:end),'k.','markersize',20,'displayname','Numerical (RK4)');
axis1=axis; hold on; ax = gca; ax.ColorOrderIndex = 1; figure(2); subplot(1,2,1); hold on
plot(t(1:10^3:end),S(1:10^3:end),'k.','markersize',20,'displayname','Numerical (RK4)');
figure(3); subplot(1,2,1); hold on; ax = gca; ax.ColorOrderIndex = 1;
plot(t(1:10^3:end),S(1:10^3:end),'k.','markersize',20,'displayname','Numerical (RK4)');
ax = gca; ax.ColorOrderIndex = 1; N=200;%Number of terms to be taken in series
a0=S0; b0=log(a0); a(1)=(beta*a0+r*a0^2-alpha*a0*b0); %b(1)=a(1)/a0;
for n=1:N-1; bsum=0; Bsum=0; for k=0:n-2, bsum=bsum+a(n-1-k)*(k+1)*b(k+1); end
    b(n)=a(n)/a0-bsum/n/a0; asum=a(n)*(r*a0-alpha*b0)+a0*(r*a(n)-alpha*b(n));%j=0 term + j=n term
    for j=1:n-1, asum=asum+a(n-j)*(r*a(j)-alpha*b(j)); end; a(n+1)=(beta*a(n)+asum)/(n+1);
end; SS=a0; m=0;mm=0; D=GaugeResum(a,['exp(' num2str(lambda,16) '*x)-1']);
for n=1:N; SS=SS+a(n)*t.^n; %power series
    if n==2 || n==6 || n==18; figure(1); subplot(1,2,1)
        plot(t,SS,'--','linewidth',2,'displayname',[num2str(n) ' term series']); axis(axis1);
    end
    if n==2 || n==6 || n==18; figure(2); m=m+1; subplot(1,2,1); ax = gca; ax.ColorOrderIndex = m;
        plot(t,SS,'--','linewidth',2,'displayname',[num2str(n) ' term series']);axis(axis1);ax=gca;
        ax.ColorOrderIndex = m; A=(VandermondeApproximant((a0),(a),(1:n),(Sinf),(lambda)));
        A=double(A); SA=Sinf;for j=1:n, SA=SA+A(j)*exp(lambda*j*t); end
        plot(t,SA,'linewidth',2,'displayname',[num2str(n) ' term Vandermonde']);
        subplot(1,2,2); ax = gca; ax.ColorOrderIndex = m;semilogy(t,abs(SS-S),'--','linewidth',2);
        ax=gca; ax.ColorOrderIndex=m; semilogy(t,abs(SA-S),'linewidth',2); hold on
    end
    if n==18 || n==32 || n==64 || n==128; figure(3);mm=mm+1;subplot(1,2,1);ax=gca;ax.ColorOrderIndex=mm;
        plot(t,SS,'--','linewidth',2,'displayname',[num2str(n) ' term series']); axis(axis1);
        ax=gca; ax.ColorOrderIndex = mm; SR=S0;for j=1:n, SR=SR+D(j)*(exp(lambda*t)-1).^j; end
        plot(t,SR,'linewidth',2,'displayname',[num2str(n) ' term resummation']);subplot(1,2,2);
        ax=gca; ax.ColorOrderIndex=mm; semilogy(t,abs(SS-S),'--','linewidth',2); hold on
        ax=gca;ax.ColorOrderIndex=mm;semilogy(t,abs(SR-S),'linewidth',2); ylim([1e-16 1e2]);
    end
end %Formatting Figures
figure(1); subplot(1,2,2);plot(1./[1:200],abs(a).^(-1./[1:200]),'k','linewidth',2);% ROOT TEST
figure(1); subplot(1,2,1); ax=gca; ax.FontSize=15;
legend('show','location','northeast','interpreter','latex','fontsize',14,'edgecolor','none')
ax.FontWeight='bold'; xlabel('$t$','fontsize',40,'interpreter','latex')
ylabel('$S$','fontsize',40,'interpreter','latex'); axis square;
set(gcf,'units','centimeters','position',[0,0,30,30]);subplot(1,2,2); ax=gca; ax.FontSize=15;
ax.FontWeight='bold'; xlabel('$1/n$','fontsize',40,'interpreter','latex')
ylabel('$|a_n|^{-1/n}$','fontsize',40,'interpreter','latex'); axis square;
set(gcf,'units','centimeters','position',[0,0,30,30]);
figure(2); subplot(1,2,1); ax=gca; ax.FontSize=15; ax.FontWeight='bold';
legend('show','location','northeast','interpreter','latex','fontsize',12,'edgecolor','none');
xlabel('$t$','fontsize',40,'interpreter','latex');
ylabel('$S$','fontsize',40,'interpreter','latex');axis square;
set(gcf,'units','centimeters','position',[0,0,30,30]);subplot(1,2,2);ax=gca;ax.FontSize=15;
ax.FontWeight='bold'; xlabel('$t$','fontsize',40,'interpreter','latex');
ylabel('error','fontsize',40,'interpreter','latex');axis square;
set(gcf,'units','centimeters','position',[0,0,30,30]);
figure(3); subplot(1,2,1);ax=gca; ax.FontSize=15; ax.FontWeight='bold';
legend('show','location','northeast','interpreter','latex','fontsize',12,'edgecolor','none');
xlabel('$t$','fontsize',40,'interpreter','latex');
ylabel('$S$','fontsize',40,'interpreter','latex'); axis square;
set(gcf,'units','centimeters','position',[0,0,30,30]);subplot(1,2,2);ax=gca;ax.FontSize=15;
ax.FontWeight='bold'; xlabel('$t$','fontsize',40,'interpreter','latex');
ylabel('error','fontsize',40,'interpreter','latex');
set(gcf,'units','centimeters','position',[0,0,30,30]);
axis square;
%RHS of ODE for Numerical Solution
function dS = f(S,alpha,r,beta)
dS=(-alpha*S*log(S)+r*S^2+beta*S); end