clear;clc;clf; %INITIAL CONDITIONS & PARAMETERS (below)
alpha=0.466089; gamma=0.1; beta=0.2; S0=0.88; I0=0.05; E0=0.07;
C=alpha*gamma*log(S0)-alpha*beta*(E0+I0+S0);
syms finf; F=exp(finf)-gamma/beta*(finf-log(S0))-E0-I0-S0;
finf=double(vpasolve(F,finf,-1));
lambda=1/2*(-alpha-gamma+sqrt((gamma-alpha)^2+4*alpha*beta*exp(finf)));
%NUMERICAL SOLUTION (RK4)
dt=0.0001; t=0:dt:100; fN=t; fN(1)=log(S0); F=[fN(1) -beta*I0];
for n=1:length(t)-1
    k1=f(F,alpha,gamma,beta,C) ; k2=f(F+k1*dt/2,alpha,gamma,beta,C) ;
    k3=f(F+k2*dt/2,alpha,gamma,beta,C) ; k4=f(F+k3*dt,alpha,gamma,beta,C) ;
    F=F+(dt/6)*(k1+2*k2+2*k3+k4); fN(n+1)=F(1);
end; figure(1); subplot(1,2,1)
plot(t(1:2*10^4:end),fN(1:2*10^4:end),'k.','markersize',20,'displayname','Numerical (RK4)');
axis1=axis; hold on; ax = gca; ax.ColorOrderIndex = 1; figure(2); subplot(1,2,1); hold on
plot(t(1:2*10^4:end),fN(1:2*10^4:end),'k.','markersize',20,'displayname','Numerical (RK4)');
%POWER SERIES SOLUTION AND APPROXIMANT
N=200;%Number of terms to be taken in series
a=zeros(1,N);at=a;A=a; a0=fN(1); b0=exp(a0); b=a; at0=a0-finf;
a(1)=-beta*I0; a(2)=(C-(gamma+alpha)*a(1)+alpha*beta*b0-alpha*gamma*a0)/2;
for n=1:N
    bsum=n*a(n)*b0;%j=n-1 term
    for j=0:n-2, bsum=bsum+(j+1)*a(j+1)*b(n-1-j); end; b(n)=bsum/n;
    a(n+2)=(alpha*beta*b(n)-(gamma+alpha)*(n+1)*a(n+1)-alpha*gamma*a(n))/(n+1)/(n+2);
    at(n)=(-lambda)^n/factorial(n)*at0;
    for j=0:n-1, at(n)=at(n)+(-lambda)^j/factorial(j)*a(n-j); end
end; a=a(1:N); at=at(1:N);
fS=a0; m=0; %ASSEMBLING POWER SERIES AND APPROXIMANT (below)
for n=1:N
    fS=fS+a(n)*t.^n;
    if n==6 || n==12 || n==18, figure(1);
        subplot(1,2,1); plot(t,fS,'--','linewidth',2,'displayname',[num2str(n) ' term series']);
        axis(axis1); hold on
    end
    if n==6 || n==12 || n==18
        figure(2); m=m+1; subplot(1,2,1); ax = gca; ax.ColorOrderIndex = m;
        plot(t,fS,'--','linewidth',2,'displayname',[num2str(n) ' term series']);
        axis(axis1); hold on; ax = gca; ax.ColorOrderIndex = m;
        [A,B]=PadeApproximant(at0,at,n/2,n/2); fAn=at0; fAd=1;
        for j=1:n/2, fAn=fAn+A(j)*t.^j; fAd=fAd+B(j)*t.^j; end; fA=finf+exp(lambda*t).*fAn./fAd;
        plot(t,fA,'linewidth',2,'displayname',...
            ['$f_\infty+e^{\lambda_1 t}$[' num2str(n/2) '/' num2str(n/2) '] approximant' ]);
        subplot(1,2,2); ax = gca; ax.ColorOrderIndex = m;
        semilogy(t,abs(fS-fN),'--','linewidth',2); hold on; ax = gca; ax.ColorOrderIndex = m;
        semilogy(t,abs(fA-fN),'linewidth',2);
    end
end
figure(1); subplot(1,2,2); plot([3:200],abs(a(3:end)).^(-1./[3:200]),'k','linewidth',2);% ROOT TEST
%FORMATTING FIGURES
figure(1); subplot(1,2,1)
legend('show','location','northeast','interpreter','latex','fontsize',12,'edgecolor','none')
ax=gca; ax.FontSize=15; ax.FontWeight='bold'; xlabel('$t$','fontsize',40,'interpreter','latex')
ylabel('$f$','fontsize',40,'interpreter','latex');
set(gcf,'units','centimeters','position',[0,0,30,30]); axis square; subplot(1,2,2); ax=gca;
ax.FontSize=15; ax.FontWeight='bold'; xlabel('$n$','fontsize',40,'interpreter','latex');
ylabel('$|a_n|^{-1/n}$','fontsize',40,'interpreter','latex');
set(gcf,'units','centimeters','position',[0,0,30,30]); axis square; axis tight;
figure(2); subplot(1,2,1)
legend('show','location','northeast','interpreter','latex','fontsize',10,'edgecolor','none');
ax=gca; ax.FontSize=15; ax.FontWeight='bold'; xlabel('$t$','fontsize',40,'interpreter','latex');
ylabel('$f$','fontsize',40,'interpreter','latex');
set(gcf,'units','centimeters','position',[0,0,30,30]); axis square; subplot(1,2,2); ax=gca;
ax.FontSize=15; ax.FontWeight='bold'; xlabel('$t$','fontsize',40,'interpreter','latex');
ylabel('error','fontsize',40,'interpreter','latex');
set(gcf,'units','centimeters','position',[0,0,30,30]);
axis square;
%RHS OF ODE FOR NUMERICAL SOLUTION
function dddF = f(F,alpha,gamma,beta,C)
dddF=[F(2) C-(gamma+alpha)*F(2)+alpha*beta*exp(F(1))-alpha*gamma*F(1)];end