clear;clc;clf
%INITIAL CONDITIONS & PARAMETERS
theta=pi/4; B=1; h0=0.536940308429026;% for theta=pi/4 and B=1;
%NUMERICAL SOLUTION (RK4)
dr=0.0001; r=0:dr:2; fN=r; fN(1)=h0; F=[fN(1) -cot(theta)];
for n=1:length(r)-1
    k1=f(F,B,r(n)) ; k2=f(F+k1*dr/2,B,r(n)+dr/2) ;
    k3=f(F+k2*dr/2,B,r(n)+dr/2) ; k4=f(F+k3*dr,B,r(n)+dr) ;
    F=F+(dr/6)*(k1+2*k2+2*k3+k4); fN(n+1)=F(1);
end; figure(1); subplot(1,2,1)
plot(r(1:10^3:end),fN(1:10^3:end),'k.','markersize',20,'displayname','Numerical (RK4)');
axis1=axis; hold on; ax = gca; ax.ColorOrderIndex = 1; figure(2); subplot(1,2,1); hold on
plot(r(1:10^3:end),fN(1:10^3:end),'k.','markersize',20,'displayname','Numerical (RK4)');
%POWER SERIES SOLUTION AND RESUMMATION
N=400;%Number of terms to be taken in series
a=zeros(1,N); a0=fN(1); d=a; b=a; a(1)=-cot(theta); b0=a(1)^2; bt0=1+b0; d0=bt0^(3/2);
a(2)=(B*a0*d0-a(1)*(b0+1))/2;
for n=1:N-2
    bsum=0;
    for j=0:n
        bsum=bsum+(j+1)*(n-j+1)*a(j+1)*a(n-j+1);
    end
    b(n)=bsum; dsum=3*n/2*b(n)*d0; %note that btilde is b for n>0
    for j=1:n-1
        dsum=dsum+(5/2*j-n)*b(j)*d(n-j); %note that btilde is b for n>0
    end
    d(n)=dsum/n/bt0;
    if n==1
        asum=B*a0*(d(1)+d0)-b(1)*a(1)+B*a(1)*d0-b0*2*a(2);%j=0 term + j=n term
    else
        asum=B*a0*(d(n)+d(n-1))-b(n)*a(1)+B*a(n)*d0-b0*(n+1)*a(n+1)+...
            B*a(n-1)*(d(1)+d0)-b(1)*n*a(n); %j=0 term + j=n term +j=n-1 term
        for j=1:n-2
            asum=asum+B*a(j)*(d(n-j)+d(n-1-j))-b(n-j)*(j+1)*a(j+1);
        end
    end
    a(n+2)=-a(n+1)*(n+1)/(n+2)+asum/(n+1)/(n+2);
end
nv=1:N; atest=abs(a).^(-1./nv); %numerical root test
Mv=nv(1:end-1).*nv(2:end).*(atest(1:end-1)-atest(2:end)); M=Mv(end); %extrapolated root test
ds=nv(2:end).*atest(2:end)-nv(1:end-1).*atest(1:end-1); %Domb--Sykes Estimate
Rnum=ds(end); R=round(Rnum,3); %ds converges to this precision for modulus of closest singularity
%%resummation coefficients with g=x/(x+R), where R is written in fractional form below
A=GaugeResum((a(1:50)),'x/(x+23/125)'); A0=a0;
%ASSEMBLING POWER SERIES AND RESUMMATION
g=r./(r+R); fA=A0; fS=a0; m=0;
for n=1:50 %PLOTTING
    fS=fS+a(n)*r.^n; fA=fA+A(n)*g.^n;
    if n==2 || n==10 || n==50, figure(1);
        subplot(1,2,1); plot(r,fS,'--','linewidth',2,'displayname',[num2str(n) ' term series']);
        axis(axis1); hold on
        figure(2); m=m+1; subplot(1,2,1); ax = gca; ax.ColorOrderIndex = m;
        plot(r,fS,'--','linewidth',2,'displayname',[num2str(n) ' term series']);
        axis(axis1); hold on; ax = gca; ax.ColorOrderIndex = m; set(gcf,'renderer','Painters')
        plot(r,fA,'linewidth',2,'displayname',[num2str(n) ' term resummation']);
        subplot(1,2,2); ax = gca; ax.ColorOrderIndex = m;
        semilogy(r,abs(fS-fN),'--','linewidth',2,'displayname',[num2str(n) ' term series']);
        hold on; ax = gca; ax.ColorOrderIndex = m;
        semilogy(r,abs(fA-fN),'linewidth',2,'displayname',[num2str(n) ' term resummation']);
    end
end
figure(1); subplot(1,2,2); % ROOT TEST
plot(1./nv(1:20:end),atest(1:20:end),'k*','markersize',10,'linewidth',2,'displayname','root test');
hold on; plot([0 0.003],M.*[0 0.003]+Rnum,'k--','linewidth',2,'displayname','linear extrapolation')
%FORMATTING FIGURES
figure(1); subplot(1,2,1)
legend('show','location','northeast','interpreter','latex','fontsize',12,'edgecolor','none')
ax=gca; ax.FontSize=15; ax.FontWeight='bold'; xlabel('$r$','fontsize',40,'interpreter','latex')
ylabel('$h$','fontsize',40,'interpreter','latex');
set(gcf,'units','centimeters','position',[0,0,30,30]); axis square; subplot(1,2,2); ax=gca;
ax.FontSize=15; ax.FontWeight='bold'; xlabel('$1/n$','fontsize',40,'interpreter','latex');
ylabel('$|a_n|^{-1/n}$','fontsize',40,'interpreter','latex');
set(gcf,'units','centimeters','position',[0,0,30,30]); axis square; xlim([0 0.005]);
legend('show','location','southeast','interpreter','latex','fontsize',12,'edgecolor','none')
figure(2); subplot(1,2,1)
legend('show','location','northeast','interpreter','latex','fontsize',12,'edgecolor','none');
ax=gca; ax.FontSize=15; ax.FontWeight='bold'; xlabel('$r$','fontsize',40,'interpreter','latex');
ylabel('$h$','fontsize',40,'interpreter','latex');
set(gcf,'units','centimeters','position',[0,0,30,30]); axis square; subplot(1,2,2); ax=gca;
ax.FontSize=15; ax.FontWeight='bold'; xlabel('$r$','fontsize',40,'interpreter','latex');
ylabel('error','fontsize',40,'interpreter','latex');
set(gcf,'units','centimeters','position',[0,0,30,30]);
ylim([1e-20 100]);axis square;
%RHS OF ODE FOR NUMERICAL SOLUTION
function dddF = f(F,B,r)
dddF=[F(2) B*F(1)*(1+F(2)^2)^(3/2)-F(2)^3/(r+1)-F(2)/(r+1)];end
