clear;clc;clf
%INITIAL CONDITIONS & PARAMETERS
omega0=0; E=1.999; theta0=acos(1-E); N=50; M=30;
%NUMERICAL SOLUTION (RK4)
dt=0.0001; t=0:dt:20.7488; fN=t; fN(1)=theta0; F=[fN(1) omega0];
for n=1:length(t)-1
    k1=f(F) ; k2=f(F+k1*dt/2) ;
    k3=f(F+k2*dt/2) ; k4=f(F+k3*dt) ;
    F=F+(dt/6)*(k1+2*k2+2*k3+k4); fN(n+1)=F(1);
end; figure(1);
plot(t(1:5*10^3:end),fN(1:5*10^3:end),'k.-','markersize',30,'displayname','Numerical (RK4)');
axis tight; axis1=axis; hold on;
%POWER SERIES SOLUTION AND RESUMMATION
a0=theta0;s0=sin(theta0); c0=cos(theta0); a=nan(1,N);c=a;s=a;b=a;ahat=a;
a(1)=omega0; a(2)=-s0/2; s(1)=a(1)*c0; c(1)=-a(1)*s0;
for n=1:N-2, ssum=(n+1)*a(n+1)*c0; csum=(n+1)*a(n+1)*s0;
    for k=0:n-1
        ssum=ssum+(k+1)*a(k+1)*c(n-k); csum=csum+(k+1)*a(k+1)*s(n-k);
    end; s(n+1)=ssum/(n+1); c(n+1)=-csum/(n+1); a(n+2)=-s(n)/(n+1)/(n+2);
    b(n+2)=a(n+2);
end; fS=a0;
for n=1:N, fS=fS+a(n)*t.^n;
    if n==20 || n==30 || n==40 || n==40
        plot(t,fS,'linewidth',3,'displayname',[num2str(n) ' term series']); axis(axis1)
    end
end
R=sqrt((K(sqrt(E/2),M))^2+(K(sqrt(1-E/2),M))^2);
plot([R R], [-5 5],'k--','linewidth',3,'displayname','$R$');axis(axis1)
%FORMATTING FIGURES
legend('show','location','north','interpreter','latex','fontsize',24,'edgecolor','none',...
    'AutoUpdate','off','color',[0.8 0.8 0.8])
ax=gca; ax.FontSize=30; ax.FontWeight='bold';
xlabel('$\tilde{t}$','fontsize',60,'interpreter','latex')
ylabel('$\tilde{\theta}$','fontsize',60,'interpreter','latex'); plot([0 21],[0 0],'k:');
plot([2*K(sqrt(E/2),M) 2*K(sqrt(E/2),M)],[- 5 5],'k:')
%RHS OF ODE FOR NUMERICAL SOLUTION
function dddF = f(F)
dddF=[F(2) -sin(F(1))];end
function F=K(k,M) %eqn A4 of Reinberger et al
n=0:M;
F=(pi/2*(factorial(2*n)./(factorial(n)).^2).^2.*16.^(-n)-1./(2*n+1))*(k.^(2*n)).'+...
    log((1+k)/(1-k))/(2*k);
end