clc; clear;clf; close all
%% parameters
set(gca,'colororder','factory')
y=0:0.01:1; N=100; a=1; b=20/9;
r0=2*b/sqrt(3).*sqrt(1-a^2./b.^2).*cos(1/3*acos(-3*sqrt(3)./b.*(1-a./b).^2./(1-a^2./b.^2).^(3/2)));
%% numerical integration
u0=1./r0; I=@(yhat) (u0*b-2*u0^2*(b-a)*yhat)./(1-...
    2*u0*yhat+a^2*u0^2*yhat.^2)./sqrt(2*(b-a)^2*u0^3*yhat.^3-(b^2-a^2)*u0^2*yhat.^2+1);
for j=1:length(y), PhiN(j)=-pi+quad(I,0,y(j),1e-4); end;figure(1); subplot(1,2,1)
plot(y(1:2:end),PhiN(1:2:end),'k.','markersize',20,'displayname','Numerical'); axis1=axis; hold on
figure(2); subplot(1,2,1); hold on
plot(y(1:2:end),PhiN(1:2:end),'k.','markersize',20,'displayname','Numerical');
%% power series solution
p=zeros(1,N); d=p;c=p; f=p; h=p; g=p; p0=u0*b; A=p; p(1)=-2*u0^2*(b-a); d0=1; d(1)=-2*u0;
d(2)=a^2*u0^2;c0=1; c(1)=0; c(2)=-(b^2-a^2)*u0^2;c(3)=2*(b-a)^2*u0^3; f0=p0/d0;h0=c0^(-1/2);g0=f0*h0;
for n=1:N; fsum=d(n)*f0; hsum=-n/2*c(n)*h0;
    for j=1:n-1, fsum=fsum+d(j)*f(n-j);hsum=hsum+(j/2-n)*c(j)*h(n-j);end
    f(n)=(p(n)-fsum)/d0; h(n)=hsum/n/c0;gsum=f0*h(n)+f(n)*h0;
    for j=1:n-1, gsum=gsum+f(j)*h(n-j);end; g(n)=gsum;
end
nv=1:N-1; atest=abs(g(1:end-1)./g(2:end)); %numerical ratio test
Mv=nv(1:end-1).*nv(2:end).*(atest(1:end-1)-atest(2:end)); M=Mv(end);%slope of extrapolated root test
ds=nv(2:end).*atest(2:end)-nv(1:end-1).*atest(1:end-1); %Domb--Sykes Estimate
Rnum=ds(end); R=round(Rnum,3); %ds converges to this precision for modulus of closest singularity
Phi0=-pi+quad(I,0,1); gt0=-pi-Phi0; gt(1)=g0; gt(2:N)=g(1:N-1)./(nv+1);
%%plotting series and assembling approximant
PhiS=-pi+g0*y; mm=0;
for n=1:N
    PhiS=PhiS+g(n)/(n+1)*y.^(n+1);
    if n==50 || n==75 || n==100, figure(1); subplot(1,2,1);
        plot(y,PhiS,'--','linewidth',2,'displayname',[num2str(n) ' term series']);
        axis(axis1); hold on
    end
    if n==2 || n==4 || n==6
        for nn=0:n; Asum=0;
            for m=nn:n; gtsum=(-1)^m*gt0/gamma(m+1)/gamma(-m+1/2);
                for j=0:m-1, gtsum=gtsum+(-1)^j*gt(m-j)/gamma(j+1)/gamma(-j+1/2);end
                Asum=Asum+gtsum*gamma(m+1)/gamma(m-nn+1);
            end
            if nn==0, A0=gamma(1/2)*Asum;else
                A(nn)=gamma(1/2)/factorial(nn)*Asum;end
        end
        PhiAsum=A0;
        for j=1:n, PhiAsum=PhiAsum+A(j)*(y-1).^j; end
        figure(2); mm=mm+1; subplot(1,2,1); ax = gca; ax.ColorOrderIndex = mm;
        plot(y,PhiS,'--','linewidth',2,'displayname',['series, $N$=' num2str(n)]);
        axis(axis1); hold on; ax = gca; ax.ColorOrderIndex = mm; set(gcf,'renderer','Painters')
        PhiA=Phi0+sqrt(1-y).*PhiAsum;
        plot(y,PhiA,'linewidth',2,'displayname',['approximant, $N$=' num2str(n)]);
        subplot(1,2,2); ax = gca; ax.ColorOrderIndex =mm; set(gcf,'renderer','Painters')
        plot(y,abs(PhiS-PhiN),'--','linewidth',2,'displayname',[num2str(n) ' term series']);
        hold on; ax = gca; ax.ColorOrderIndex = mm;set(gcf,'renderer','Painters')
        plot(y,abs(PhiA-PhiN),'linewidth',2,'displayname',[num2str(n) ' term approximant']);
    end
end
figure(1); subplot(1,2,2); % RATIO TEST
plot(1./nv(1:10:end),atest(1:10:end),'k*','markersize',10,'linewidth',2,'displayname','ratio test');
hold on; plot([0 1],M.*[0 1]+Rnum,'k--','linewidth',2,'displayname','linear extrapolation')
% FORMATTING FIGURES
figure(1); subplot(1,2,1)
legend('show','location','northwest','interpreter','latex','fontsize',12,'edgecolor','none')
ax=gca; ax.FontSize=15; ax.FontWeight='bold'; xlabel('$y$','fontsize',40,'interpreter','latex')
ylabel('$\phi$','fontsize',40,'interpreter','latex');
set(gcf,'units','centimeters','position',[0,0,30,30]); axis square; subplot(1,2,2); ax=gca;
ax.FontSize=15; ax.FontWeight='bold'; xlabel('$1/n$','fontsize',40,'interpreter','latex');
ylabel('$|a_n/a_{n+1}|$','fontsize',40,'interpreter','latex');
set(gcf,'units','centimeters','position',[0,0,30,30]); axis square; xlim([0 .02]);
legend('show','location','southeast','interpreter','latex','fontsize',12,'edgecolor','none')
figure(2); subplot(1,2,1)
legend('show','location','northwest','interpreter','latex','fontsize',12,'edgecolor','none');
ax=gca; ax.FontSize=15; ax.FontWeight='bold'; xlabel('$y$','fontsize',40,'interpreter','latex');
ylabel('$\phi$','fontsize',40,'interpreter','latex');
set(gcf,'units','centimeters','position',[0,0,30,30]); axis square; subplot(1,2,2); ax=gca;
ax.FontSize=15; ax.FontWeight='bold'; xlabel('$y$','fontsize',40,'interpreter','latex');
ylabel('error','fontsize',40,'interpreter','latex');
set(gcf,'units','centimeters','position',[0,0,30,30]);
ylim([0 1]); axis square;