%%example 2.3.3
clear;clc;clf
%INITIAL CONDITIONS & PARAMETERS
dk=0.01; k=0:dk:1-dk; K=nan(size(k));
%MATLAB's BUILT-IN FUNCTION
K(k<1)=ellipke(k(k<1).^2);
plot(k,K)
subplot(1,2,1);
plot(k(1:5:end),K(1:5:end),'k.','markersize',20,'displayname','ellipke MATLAB function');
axis1=axis; hold on; ax = gca; ax.ColorOrderIndex = 1;
%POWER SERIES SOLUTION
N=100; Ksum=pi/2; m=0; Kresum=pi/2+-1+1./(2*k).*log((1+k)./(1-k));
for n=1:N
    Ksum=Ksum+pi/2*(factorial(2*n)/(factorial(n))^2)^2*16^(-n)*k.^(2*n);
    Kresum=Kresum+pi/2*(factorial(2*n)/(factorial(n))^2)^2*16^(-n)*k.^(2*n)-k.^(2*n)/(2*n+1);
    %PLOTTING
    if n==1 || n==5 || n==25
        m=m+1;
        subplot(1,2,1)
        ax = gca; ax.ColorOrderIndex = m;
        plot(k,Ksum,'--','linewidth',2,'displayname',[num2str(n) ' term series']);
        ax = gca; ax.ColorOrderIndex = m;
        plot(k,Kresum,'linewidth',2,'displayname',[num2str(n) ' term resummation']);
        subplot(1,2,2); ax = gca; ax.ColorOrderIndex = m;
        semilogy(k,abs(Ksum-K),'--','linewidth',2,'displayname',[num2str(n) ' term series']);
        hold on; ax = gca; ax.ColorOrderIndex = m;
        semilogy(k,abs(Kresum-K),'linewidth',2,'displayname',[num2str(n) ' term resummation']);
    end
end
%
%% % %Formatting Figures
subplot(1,2,1)
legend('show','location','northwest','interpreter','latex','fontsize',10,'edgecolor','none')
ax=gca; ax.FontSize=15; ax.FontWeight='bold'; xlabel('$k$','fontsize',40,'interpreter','latex')
ylabel('$K$','fontsize',40,'interpreter','latex');
set(gcf,'units','centimeters','position',[0,0,30,30]);
axis square;
subplot(1,2,2); ax=gca;
ax.FontSize=15; ax.FontWeight='bold'; xlabel('$k$','fontsize',40,'interpreter','latex');
ylabel('error','fontsize',40,'interpreter','latex');
set(gcf,'units','centimeters','position',[0,0,30,30]);
ylim([1e-17 10^2]);axis square;