clear;clc;clf
%INITIAL CONDITIONS & PARAMETERS
alpha=2; gamma=0; kappa=0.332057336215196; R=5.6900380545;% for beta=0
%NUMERICAL SOLUTION (RK4)
deta=0.0001; eta=0:deta:8; fN=eta; fN(1)=0; F=[fN(1) gamma kappa];
for n=1:length(eta)-1
    k1=f(F,alpha) ; k2=f(F+k1*deta/2,alpha) ;
    k3=f(F+k2*deta/2,alpha) ; k4=f(F+k3*deta,alpha) ;
    F=F+(deta/6)*(k1+2*k2+2*k3+k4); fN(n+1)=F(1);
end; figure(1); subplot(1,2,1)
plot(eta(1:2*10^3:end),fN(1:2*10^3:end),'k.','markersize',20,'displayname','Numerical (RK4)');
axis1=axis; hold on; ax = gca; ax.ColorOrderIndex = 1;
%POWER SERIES SOLUTION AND RESUMMATION
N=9*3*3*3;%Number of terms to be taken in series
a=zeros(1,N);at=a; a0=fN(1);
a(1)=gamma; a(2)=kappa/2; a(3)=(-2*a0*a(2))/6/alpha; at(1)=a(1)-1;
at(2)=a(2); at(3)=a(3);
for n=1:N
    asum=a(n)*(-2*a(2))+a0*(-(n+1)*(n+2)*a(n+2));%j=0 term + j=n term
    for j=1:n-1
        asum=asum+a(n-j)*(-(j+1)*(j+2)*a(j+2));
    end
    a(n+3)=asum/alpha/(n+1)/(n+2)/(n+3); at(n+3)=a(n+3);
end
a=a(1:N); at=at(5:3:end);
A=EulerSum(at,R^3); NN=length(A);
%ASSEMBLING POWER SERIES AND RESUMMATION
fS=a(2)*eta.^2; fAsum=a(2); m=0; g=eta.^3./(eta.^3+R^3);
for n=1:NN
    fS=fS+at(n)*eta.^(3*n+2); fAsum=fAsum+A(n)*g.^n;
    %PLOTTING
    if n==3 || n==9 || n==27
        figure(1); m=m+1; subplot(1,2,1); ax = gca; ax.ColorOrderIndex = m;
        plot(eta,fS,'--','linewidth',2,'displayname',[num2str(n) ' term series']);
        axis(axis1); hold on; ax = gca; ax.ColorOrderIndex = m;
        fA=eta.^2.*fAsum; plot(eta,fA,'linewidth',2,'displayname',[num2str(n) ' term resummation']);
        subplot(1,2,2); ax = gca; ax.ColorOrderIndex = m;
        semilogy(eta,abs(fS-fN),'--','linewidth',2,'displayname',[num2str(n) ' term series']);
        hold on; ax = gca; ax.ColorOrderIndex = m;
        semilogy(eta,abs(fA-fN),'linewidth',2,'displayname',[num2str(n) ' term resummation']);
    end
end
%FORMATTING FIGURES
figure(1); subplot(1,2,1)
legend('show','location','northwest','interpreter','latex','fontsize',10,'edgecolor','none');
ax=gca; ax.FontSize=15; ax.FontWeight='bold'; xlabel('$\eta$','fontsize',40,'interpreter','latex');
ylabel('$f$','fontsize',40,'interpreter','latex');
set(gcf,'units','centimeters','position',[0,0,30,30]); axis square; subplot(1,2,2); ax=gca;
ax.FontSize=15; ax.FontWeight='bold'; xlabel('$\eta$','fontsize',40,'interpreter','latex');
ylabel('error','fontsize',40,'interpreter','latex');
set(gcf,'units','centimeters','position',[0,0,30,30]);
% ylim([1e-10 100]);
axis square;
%RHS OF ODE FOR NUMERICAL SOLUTION
function dddF = f(F,alpha)
dddF=[F(2) F(3) (-F(1)*F(3))/alpha];end