clc;clear;clf; psivals=17; cmap=parula(psivals);
set(groot,'defaultAxesColorOrder',flipud(cmap));
N=27;% number of terms in resummation
eta=0:0.1:6; boxsize=30; etaval=5; %value to draw y(x) envelope for
[fA,dfA]=Blasius(eta,N); %resummation given by function at the end
subplot(2,2,1.5); plot(eta,dfA,'k','linewidth',2); axis tight; hold on
plot([0 etaval],[0.997 0.997],'k--'); plot([etaval etaval],[0 0.997],'k--');
nu=1; U=1; eta=0:0.1:etaval; fA=fA(1:length(eta));
for psi=psivals:-1:1 %plot streamlines
    y=psi/U*eta./fA; x=psi^2/nu/U./fA.^2; subplot(2,2,3)
    plot(x*nu*U,y*U,'linewidth',2,'displayname',['$\psi$=' num2str(psi)]); hold on
end
x1=0.01:0.01:boxsize; y1=etaval*sqrt(x1*nu/U); plot(x1*nu*U,y1*U,'k--','linewidth',2)
%text(25,15,'$y(x)$ for $\eta=5$','interpreter','latex','Rotation',30,'FontSize'
subplot(2,2,4); %plot velocity field
xbar=0.01:0.01:boxsize; ybar=xbar; x=xbar/nu/U; y=ybar/U;
[X,Y]=meshgrid(x,y); eta=Y.*sqrt(U/nu./X); [fA,dfA]=Blasius(eta,N);
pcolor(xbar,ybar,dfA); shading flat; h=colorbar;caxis([0 1]);
hold on; plot(x1*nu*U,y1*U,'k--','linewidth',2);
subplot(2,2,1.5)
ax=gca; ax.FontSize=15; ax.FontWeight='bold';
xlabel('$\eta$','fontsize',40,'interpreter','latex');
ylabel('$df/d\eta$','fontsize',40,'interpreter','latex');
set(gcf,'units','centimeters','position',[0,0,30,30]);
axis square; axis([0 6 0 1.2])
subplot(2,2,3)
ax=gca; ax.FontSize=15; ax.FontWeight='bold';
xlabel('$x\nu U_\infty$','fontsize',40,'interpreter','latex');
ylabel('$yU_\infty$','fontsize',40,'interpreter','latex');
set(gcf,'units','centimeters','position',[0,0,30,30]);
axis([0 boxsize 0 boxsize]);
axis square;
subplot(2,2,4)
ax=gca; ax.FontSize=15; ax.FontWeight='bold';
xlabel('$x\nu U_\infty$','fontsize',40,'interpreter','latex');
ylabel('$yU_\infty$','fontsize',40,'interpreter','latex');
ylabel(h,'$u/U_\infty$','fontsize',40,'interpreter','latex');
set(gcf,'units','centimeters','position',[0,0,30,30]);
axis square;
function [fA,dfA]=Blasius(eta,N)
alpha=2; gamma=0; kappa=0.332057336215196; R=5.6900380545;% for beta=0
a=zeros(1,N);at=a; a0=0;
a(1)=gamma; a(2)=kappa/2; a(3)=(-2*a0*a(2))/6/alpha; at(1)=a(1)-1;
at(2)=a(2); at(3)=a(3);
for n=1:N
    asum=a(n)*(-2*a(2))+a0*(-(n+1)*(n+2)*a(n+2));%j=0 term + j=n term
    for j=1:n-1
        asum=asum+a(n-j)*(-(j+1)*(j+2)*a(j+2));
    end
    a(n+3)=asum/alpha/(n+1)/(n+2)/(n+3); at(n+3)=a(n+3);
end
a=a(1:N); at=at(5:3:end);
A=EulerSum(at,R^3); NN=length(A);
%ASSEMBLING RESUMMATION
fAsum=a(2); g=eta.^3./(eta.^3+R^3); dg=(3*R^3*eta.^2)./(R^3 + eta.^3).^2;
dfAsum=0;
for n=1:NN
    fAsum=fAsum+A(n)*g.^n;
    dfAsum=dfAsum+n*A(n)*g.^(n-1).*dg;
end
fA=eta.^2.*fAsum;
dfA=2*eta.*fAsum+eta.^2.*dfAsum;
end