clear;clc;clf
%input parameters
kappa=0.332057336215196299183; R=5.6900380545;
N=100; %number of terms in Eulerized series
%original series coefficients for f(eta)
a0=0;a(1)=0;a(2)=kappa/2;a(3)=0;
for n=1:3*N
    sum=0;
    for j=0:n
        if n==j
            sum=sum+a0*(j+1)*(j+2)*a(j+2);
        else
            sum=sum+a(n-j)*(j+1)*(j+2)*a(j+2);
        end
    end
    a(n+3)=-sum/2/(n+1)/(n+2)/(n+3);
end
at=a(5:3:end);%series coefficients for f(eta^3)/eta^2;
Aold=EulerSum(at,R^3);%Eulerization of the series for f(eta^3)/eta^2, example 4.2.3;
%constructing series of example 4.2.5, equivalent to above Eulerization
C=R^3;A0=kappa/2; A=zeros(1,N);alpha=A; beta=A; lambda=A; omega=A; delta=A;
A(1)=-C/240*kappa^2; A(2)=A(1)+11*kappa^3*C^2/161280;
A(3)=(18*A(2)*(108-C*A0)+12*(112*A(2)-109*A(1))-...
    18*C*(-2*A0*A(1)+A(1)^2+2*A0*A(2))-2*C*(2*A0*A(2)+A(1)^2))/(54*6+108*12+360);
alpha0=0; alpha(2)=1; alpha(3)=-4; alpha(4)=6; alpha(5)=-4; alpha(6)=1;
beta0=0; beta(1)=2; beta(2)=-9; beta(3)=15; beta(4)=-11; beta(5)=3;
lambda0=0; lambda(2)=1; lambda(3)=-2; lambda(4)=1;
omega0=10; omega(1)=-56; omega(2)=109; omega(3)=-90; omega(4)=27;
delta0=0; delta(1)=1; delta(2)=-2; delta(3)=1;
for n=3:N-1
    alphasum=0;
    for j=0:n-3
        alphasum=alphasum+(j+1)*(j+2)*(j+3)*A(j+3)*alpha(n-j);
    end
    betasum=0; lambdasum=0;
    for j=0:n-2
        betasum=betasum+(j+1)*(j+2)*A(j+2)*beta(n-j);
        bsum1=(j+1)*(j+2)*A(j+2)*A0;
        for k=0:j-1
            bsum1=bsum1+(k+1)*(k+2)*A(k+2)*A(j-k);
        end
        lambdasum=lambdasum+lambda(n-j)*bsum1;
    end
    omegasum=0; deltasum=0;
    for j=0:n-1
        omegasum=omegasum+(j+1)*A(j+1)*omega(n-j);
        bsum2=(j+1)*A(j+1)*A0;
        for k=0:j-1
            bsum2=bsum2+(k+1)*A(k+1)*A(j-k);
        end
        deltasum=deltasum+delta(n-j)*bsum2;
    end
    bsum3=2*A0*A(n);
    for j=1:n-1
        bsum3=bsum3+A(j)*A(n-j);
    end
    A(n+1)=(-54*alphasum-108*betasum-9*C*lambdasum-12*omegasum-...
        18*C*deltasum-2*C*bsum3)/(54*n^3+216*n^2+282*n+120);
end
semilogy(abs(at),'linewidth',2,'displayname','$|\tilde{a}_n|$'); hold on
semilogy(abs(Aold),'linewidth',2,'displayname','$|A_n|$ (Euler Resummation, example 4.2.3)');
semilogy(abs(A),'linewidth',2,'displayname','$|A_n|$ (Indirect Resummation, example 4.2.5)');
%Formatting Figures
legend('show','location','northwest','interpreter','latex','fontsize',13,'edgecolor','none')
ax=gca; ax.FontSize=15; ax.FontWeight='bold'; xlabel('$n$','fontsize',40,'interpreter','latex')
set(gcf,'units','centimeters','position',[0,0,30,30]);
axis square;