clear;clc;clf %INITIAL CONDITIONS & PARAMETERS
alpha=2; gam=0; kappa=0.332057336215196; R=5.6900380545; B=-1.7207876575205;
deta=0.0001; eta=0:deta:32; fN=eta; fN(1)=0; F=[fN(1) gam kappa];%NUMERICAL SOLUTION (RK4)
for n=1:length(eta)-1
    k1=f(F,alpha); k2=f(F+k1*deta/2,alpha);k3=f(F+k2*deta/2,alpha);
    k4=f(F+k3*deta,alpha); F=F+(deta/6)*(k1+2*k2+2*k3+k4); fN(n+1)=F(1);
end; fNtrim=fN(1:5*10^3:end);
N=9*3*3*3;%Number of terms to be taken in series
a0=fN(1);a(1)=gam; a(2)=kappa/2;
C=R^3;A0=kappa/2; A=zeros(1,N);alpha=A; beta=A; lambda=A; omega=A; delta=A;
A(1)=-C/240*kappa^2; A(2)=A(1)+11*kappa^3*C^2/161280;
A(3)=(18*A(2)*(108-C*A0)+12*(112*A(2)-109*A(1))-...
    18*C*(-2*A0*A(1)+A(1)^2+2*A0*A(2))-2*C*(2*A0*A(2)+A(1)^2))/(54*6+108*12+360);
alpha0=0; alpha(2)=1; alpha(3)=-4; alpha(4)=6; alpha(5)=-4; alpha(6)=1;
beta0=0; beta(1)=2; beta(2)=-9; beta(3)=15; beta(4)=-11; beta(5)=3;
lambda0=0; lambda(2)=1; lambda(3)=-2; lambda(4)=1;
omega0=10; omega(1)=-56; omega(2)=109; omega(3)=-90; omega(4)=27;
delta0=0; delta(1)=1; delta(2)=-2; delta(3)=1;
for n=3:N-1; alphasum=0;
    for j=0:n-3, alphasum=alphasum+(j+1)*(j+2)*(j+3)*A(j+3)*alpha(n-j);
    end; betasum=0; lambdasum=0;
    for j=0:n-2, betasum=betasum+(j+1)*(j+2)*A(j+2)*beta(n-j);
        bsum1=(j+1)*(j+2)*A(j+2)*A0;
        for k=0:j-1, bsum1=bsum1+(k+1)*(k+2)*A(k+2)*A(j-k);
        end; lambdasum=lambdasum+lambda(n-j)*bsum1;
    end;omegasum=0; deltasum=0;
    for j=0:n-1
        omegasum=omegasum+(j+1)*A(j+1)*omega(n-j);bsum2=(j+1)*A(j+1)*A0;
        for k=0:j-1, bsum2=bsum2+(k+1)*A(k+1)*A(j-k); end
        deltasum=deltasum+delta(n-j)*bsum2;
    end; bsum3=2*A0*A(n);
    for j=1:n-1, bsum3=bsum3+A(j)*A(n-j);end
    A(n+1)=(-54*alphasum-108*betasum-9*C*lambdasum-12*omegasum-...
        18*C*deltasum-2*C*bsum3)/(54*n^3+216*n^2+282*n+120);
end
NN=length(A); nv=1:NN;%ASSEMBLING RESUMMATION
c=(-1).^nv/R./gamma(nv+1).*(B/R*gamma(5/3)./gamma(5/3-nv)+gamma(4/3)./gamma(4/3-nv));
[b0,b]=seriesdiv(a(2),A,B/R^2+1/R,c);
fAsum=a(2); m=0; g=eta.^3./(eta.^3+R^3); fbsum=b0;
for n=1:NN %PLOTTING
    fAsum=fAsum+A(n)*g.^n;fbsum=fbsum+b(n)*g.^n;
    if n==3 || n==9 || n==27 || n==81 || n==162
        fA=eta.^2.*fAsum; m=m+1; ax = gca; ax.ColorOrderIndex = m;
        semilogy(eta,abs(fA-fN),'linewidth',3,'displayname',[num2str(n) ' term Euler resum']);
        hold on; ax = gca; ax.ColorOrderIndex = m; etatrim=eta(1:5*10^3:end);
        fb=eta.^2.*(1/R*(1-g).^(1/3)+B/R^2*(1-g).^(2/3)).*(fbsum+0*(1-sum(b(1:n))-b0)*g.^(n+1));
        fbtrim=fb(1:5*10^3:end); error=abs(fbtrim-fNtrim);
        semilogy(etatrim,error,'.','markersize',30,'displayname',[num2str(n) ' term hybrid resum']);
    end
end
figure(1); ax=gca;%FORMATTING FIGURES
legend('show','location','southeast','interpreter','latex','fontsize',24,'edgecolor','none');
ax.FontSize=30; ax.FontWeight='bold'; xlabel('$\eta$','fontsize',60,'interpreter','latex');
ylabel('error','fontsize',60,'interpreter','latex');
set(gcf,'units','centimeters','position',[0,0,30,30]);
axis square;
%RHS OF ODE FOR NUMERICAL SOLUTION
function dddF = f(F,alpha)
dddF=[F(2) F(3) (-F(1)*F(3))/alpha];end