%% Sakiadis power series and resummation
clear;clc;clf
%INITIAL CONDITIONS & PARAMETERS
alpha=2; gamma=1; kappa=-0.443748313368861;
C=1.616125446804603717; G=-2.1313459240475714821;
%NUMERICAL SOLUTION (RK4)
deta=0.0001; eta=0:deta:10; fN=eta; fN(1)=0; F=[fN(1) gamma kappa];
for n=1:length(eta)-1
    k1=f(F,alpha) ; k2=f(F+k1*deta/2,alpha) ;
    k3=f(F+k2*deta/2,alpha) ; k4=f(F+k3*deta,alpha) ;
    F=F+(deta/6)*(k1+2*k2+2*k3+k4); fN(n+1)=F(1);
end; subplot(1,2,1); hold on
plot(eta(1:2*10^3:end),fN(1:2*10^3:end),'k.','markersize',20,'displayname','Numerical (RK4)');
axis1=axis;
%POWER SERIES SOLUTION AND RESUMMATION
N=100;%Number of terms to be taken in series
a=zeros(1,N); A=a; a0=fN(1); A0=C; A(1)=G; A(2)=G^2/(4*C);
a(1)=gamma; a(2)=kappa/2; a(3)=(-2*a0*a(2))/6/alpha;
for n=1:N
    asum=a(n)*(-2*a(2))+a0*(-(n+1)*(n+2)*a(n+2));%j=0 term + j=n term
    Asum=n^2*A(n)*A(1);
    for j=1:n-1
        asum=asum+a(n-j)*(-(j+1)*(j+2)*a(j+2)); Asum=Asum+j^2*A(j)*A(n-j+1);
    end
    a(n+3)=asum/alpha/(n+1)/(n+2)/(n+3); A(n+1)=Asum/C/n/(n+1)^2;
end;a=a(1:N);
%ASSEMBLING POWER SERIES AND RESUMMATION
fS=a0; fA=A0; m=0;
for n=1:N
    fS=fS+a(n)*eta.^n; fA=fA+A(n)*exp(-n*C*eta/2);
    %PLOTTING
    if n==2 || n==10 || n==50
        m=m+1; subplot(1,2,1); ax = gca; ax.ColorOrderIndex = m;
        plot(eta,fS,'--','linewidth',2,'displayname',[num2str(n) ' term series']);
        axis(axis1); hold on; ax = gca; ax.ColorOrderIndex = m;
        plot(eta,fA,'linewidth',2,'displayname',[num2str(n) ' term resummation']);
        subplot(1,2,2); ax = gca; ax.ColorOrderIndex = m;
        semilogy(eta,abs(fS-fN),'--','linewidth',2,'displayname',[num2str(n) ' term series']);
        hold on; ax = gca; ax.ColorOrderIndex = m;
        semilogy(eta,abs(fA-fN),'linewidth',2,'displayname',[num2str(n) ' term resummation']);
    end
end
%FORMATTING FIGURES
subplot(1,2,1)
legend('show','location','southeast','interpreter','latex','fontsize',10,'edgecolor','none');
ax=gca; ax.FontSize=15; ax.FontWeight='bold'; xlabel('$\eta$','fontsize',40,'interpreter','latex');
ylabel('$f$','fontsize',40,'interpreter','latex');
set(gcf,'units','centimeters','position',[0,0,30,30]); axis square; subplot(1,2,2); ax=gca;
ax.FontSize=15; ax.FontWeight='bold'; xlabel('$\eta$','fontsize',40,'interpreter','latex');
ylabel('error','fontsize',40,'interpreter','latex');
set(gcf,'units','centimeters','position',[0,0,30,30]);
ylim([1e-20 10]);axis square;
%RHS OF ODE FOR NUMERICAL SOLUTION
function dddF = f(F,alpha,beta)
dddF=[F(2) F(3) (-F(1)*F(3))/alpha];end