%%flat wall meniscus power series and resummation
clear;clc;clf
%INITIAL CONDITIONS & PARAMETERS
theta=pi/4;
C=4*sqrt(1-sin(theta))*exp(-2+sqrt(2+2*sin(theta)))/(sqrt(1+sin(theta))+sqrt(2));
%NUMERICAL SOLUTION (RK4)
dx=0.0001; x=0:dx:2.5; hN=x; hN(1)=sqrt(2*(1-sin(theta)));
for n=1:length(x)-1
    k1=f(hN(n)) ; k2=f(hN(n)+k1*dx/2) ;
    k3=f(hN(n)+k2*dx/2) ; k4=f(hN(n)+k3*dx) ;
    hN(n+1)=hN(n)+(dx/6)*(k1+2*k2+2*k3+k4);
end; subplot(1,2,1);
plot(x(1:2*10^3:end),hN(1:2*10^3:end),'k.','markersize',20,'displayname','Numerical (RK4)');
axis1=axis; hold on
%POWER SERIES SOLUTION AND RESUMMATION
N=100;%Number of terms to be taken in series
a=zeros(1,N);b=a; c=a; d=a; a0=hN(1); b0=a0^2; c0=(b0-2)^(-2); d0=sqrt(c0-1/4); a(1)=-2*d0;
A0=C; B0=A0^2; D0=2; A=a; B=a; D=a;
for n=1:N
    bsum=2*a0*a(n);
    for j=1:n-1
        bsum=bsum+a(j)*a(n-j);
    end; b(n)=bsum; csum=(-2*n)*b(n)*c0;
    for j=1:n-1
        csum=csum+(-j-n)*b(j)*c(n-j);
    end; c(n)=1/n*csum/(b0-2);
    dsum=n/2*c(n)*d0;
    if n==1, Dsum=-B0*D0/2; else
        Dsum=(n-3/2)*B0*D(n-1)-n/2*B(n-1)*D0; end
    for j=2:n-1
        Dsum=Dsum+(n-3/2*j)*B(j-1)*D(n-j);
    end; D(n)=Dsum/4/n;
    if n==1, Asum=A0*(B0+D(1)); else
        Asum=A0*(B(n-1)+D(n))+A(n-1)*((2*n-1)*B0+D(1)); end
    for j=1:n-2
        Asum=Asum+A(j)*((1+2*j)*B(n-j-1)+D(n-j));
    end; A(n)=Asum/(4*n); Bsum=2*A0*A(n);
    for j=1:n-1
        dsum=dsum+(3*j/2-n)*c(j)*d(n-j); Bsum=Bsum+A(j)*A(n-j);
    end; d(n)=4*dsum/n/(4*c0-1); B(n)=Bsum; a(n+1)=-2*d(n)/(n+1);
end;a=a(1:N); x=x(1:10:end); hN=hN(1:10:end);
%ASSEMBLING POWER SERIES AND RESUMMATION
hS=a0; hA=A0*exp(-x); m=0;
for n=1:N
    hS=hS+a(n)*x.^n; hA=hA+A(n)*exp(-2*n*x-x);
    %PLOTTING
    if n==2 || n==10 || n==50
        m=m+1; subplot(1,2,1); ax = gca; ax.ColorOrderIndex = m;
        plot(x,hS,'--','linewidth',2,'displayname',[num2str(n) ' term series']);
        axis(axis1); hold on; ax = gca; ax.ColorOrderIndex = m;
        plot(x,hA,'linewidth',2,'displayname',[num2str(n) ' term resummation']);
        subplot(1,2,2); ax = gca; ax.ColorOrderIndex = m;
        semilogy(x,abs(hS-hN),'--','linewidth',2,'displayname',[num2str(n) ' term series']);
        hold on; ax = gca; ax.ColorOrderIndex = m;
        semilogy(x,abs(hA-hN),'linewidth',2,'displayname',[num2str(n) ' term resummation']);
    end
end
% %FORMATTING FIGURES
subplot(1,2,1)
legend('show','location','northeast','interpreter','latex','fontsize',10,'edgecolor','none');
ax=gca; ax.FontSize=15; ax.FontWeight='bold'; xlabel('$x$','fontsize',40,'interpreter','latex');
ylabel('$h$','fontsize',40,'interpreter','latex');
set(gcf,'units','centimeters','position',[0,0,30,30]); axis square; subplot(1,2,2); ax=gca;
ax.FontSize=15; ax.FontWeight='bold'; xlabel('$x$','fontsize',40,'interpreter','latex');
ylabel('error','fontsize',40,'interpreter','latex');
set(gcf,'units','centimeters','position',[0,0,30,30]);
ylim([1e-20 10]);axis square;
%RHS OF ODE FOR NUMERICAL SOLUTION
function dhdx = f(h)
dhdx=-sqrt(1/(1-1/2*h^2)^2-1);end