%% SIR Dirichlet Series
clear;clc;clf %INITIAL CONDITIONS & PARAMETERS (below)
S0=254; I0=7; alpha=2.73; r=0.0178; beta=alpha*log(S0)-r*(S0+I0);
syms Sinf; F=beta+r*Sinf-alpha*log(Sinf);
Sinf=double(vpasolve(F,Sinf,0.1)); %iterCive solver to find Sinf
lambda=r*Sinf-alpha; % asymptotic exponential damping
%NUMERICAL SOLUTION (RK4)
dt=0.0001; t=0:dt:6; S=t; S(1)=S0;
for n=1:length(t)-1
    k1=f(S(n),alpha,r,beta); k2=f(S(n)+k1*dt/2,alpha,r,beta) ;
    k3=f(S(n)+k2*dt/2,alpha,r,beta); k4=f(S(n)+k3*dt,alpha,r,beta) ;
    S(n+1)=S(n)+(dt/6)*(k1+2*k2+2*k3+k4);
end;subplot(1,2,1)
plot(t(1:10^3:end),S(1:10^3:end),'k.','markersize',20,'displayname','Numerical (RK4)');
axis1=axis; hold on; ax = gca; ax.ColorOrderIndex = 1;
%POWER SERIES SOLUTION
N=250;%Number of terms to be taken in series
C0=Sinf; B0=log(C0); C(1)=6.32343405470896e+02; %
for n=1:N-1
    Bsum=0; %using n-index on b (instead of j) to save on index use
    for k=0:n-2, Bsum=Bsum+C(n-1-k)*(k+1)*B(k+1); end
    B(n)=C(n)/C0-Bsum/n/C0; Csum=0;%j=0 term + j=n term
    for j=1:n, Csum=Csum+C(n+1-j)*(r*C(j)+B(j)*alpha*(j/(n+1)-1)); end
    C(n+1)=Csum/(lambda*(n+1)-beta-2*r*C0+alpha*(B0+1));
end; m=0;
for n=1:N %assembling and plotting
    if n==2 || n==10 || n==250
        m=m+1; subplot(1,2,1); ax = gca; ax.ColorOrderIndex = m; hold on; axis(axis1)
        SC=Sinf;
        for j=1:n, SC=SC+C(j)*exp(lambda*j*t); end; SC(t<0.5)=nan;
        plot(t,SC,'linewidth',2,'displayname',[num2str(n) ' term Dirichlet series']);
    end
end
subplot(1,2,2);plot(1./[1:250],abs(C).^(-1./[1:250]),'k','linewidth',2);% ROOT TEST
subplot(1,2,1) %Formatting Figures
legend('show','location','northeast','interpreter','latex','fontsize',14,'edgecolor','none')
ax=gca; ax.FontSize=15; ax.FontWeight='bold'; xlabel('$t$','fontsize',40,'interpreter','latex')
ylabel('$S$','fontsize',40,'interpreter','latex');
set(gcf,'units','centimeters','position',[0,0,30,30]); axis square; subplot(1,2,2)
ax=gca; ax.FontSize=15; ax.FontWeight='bold'; xlabel('$1/n$','fontsize',40,'interpreter','latex')
ylabel('$|C_n|^{-1/n}$','fontsize',40,'interpreter','latex');
set(gcf,'units','centimeters','position',[0,0,30,30]); axis square;
%RHS of ODE for Numerical Solution
function dS = f(S,alpha,r,beta)
dS=(-alpha*S*log(S)+r*S^2+beta*S);
end