%black hole light trajectories
clear;clc;clf
a=1; b=[20/3 4 20/9];
r0=2*b/sqrt(3).*sqrt(1-a^2./b.^2).*cos(1/3*acos(-3*sqrt(3)./b.*(1-a./b).^2./(1-a^2./b.^2).^(3/2)));
%%use a different colormap than used for number of terms in previous plot
co = [0 0 1;0 0.5 0;0.9290 0.6940 0.1250;0 0.75 0.75;0.75 0 0.75;0.75 0.75 0;0.25 0.25 0.25];
set(groot,'defaultAxesColorOrder',co); a=1;m=0;
for nn=1:length(b); u0=1./r0;
    %%getting the angle and plotting the trajectory
    I=@(yhat)(u0(nn)*b(nn)-2*u0(nn)^2*(b(nn)-a)*yhat)./(1-...
        2*u0(nn)*yhat+a^2*u0(nn)^2*yhat.^2)./sqrt(2*(b(nn)-a)^2*u0(nn)^3*yhat.^3-...
        (b(nn)^2-a^2)*u0(nn)^2*yhat.^2+1); y=0:0.1:1; r=r0(nn)./y; m=m+1;
    phi0=-pi+quad(I,0,1);phi1=r; phi2=r;
    for n=1:length(r) %numerical
        phi1(n)=-pi+quad(I,0,y(n),1e-12); phi2(n)=2*phi0-phi1(n);
    end; phi1(end)=phi0;phi2(end)=phi0;
    Phi=[(phi1) phi2]; R=[(r) r];
    plot(R.*cos(Phi),R.*sin(Phi),'.','markersize',30,...
        'displayname',['Numerical, $b$=' num2str(rats(b(nn)))])
    hold on; ax = gca; ax.ColorOrderIndex = m; set(gcf,'renderer','Painters')
    y=0:0.0001:1; r=r0(nn)./y; phi1A=y; phi2A=y;
    for n=1:length(y)-1 %analytical
        phi1A(n)=getPhi(b(nn),u0(nn),y(n),a,6,phi0);phi2A(n)=2*phi0-phi1A(n);
    end; phi1A(end)=phi0;phi2A(end)=phi0;
    PhiA=[(phi1A) phi2A]; R=[(r) r];
    plot(R.*cos(PhiA),R.*sin(PhiA),'linewidth',2,...
        'displayname',['$N$=6 approximant, $b$=' num2str(rats(b(nn)))]);
    axis equal; ylim([-10 10]); xlim([-10 10])
end
legend('show','location','northwest','interpreter','latex','fontsize',20,'edgecolor','none')
ax=gca; ax.FontSize=30; ax.FontWeight='bold';
xlabel('$X$','fontsize',60,'interpreter','latex')
ylabel('$Y$','fontsize',60,'interpreter','latex');
set(gcf,'units','centimeters','position',[0,0,30,30]);
set(gcf,'units','centimeters','position',[0,0,30,30]);
function PhiA=getPhi(b,u0,y,a,N,phi0)
%the approximant
p=zeros(1,N); d=p;c=p; f=p; h=p; g=p;gt=p;A=p;
p0=u0*b; p(1)=-2*u0^2*(b-a); d0=1; d(1)=-2*u0;
d(2)=a^2*u0^2;c0=1; c(1)=0; c(2)=-(b^2-a^2)*u0^2;
c(3)=2*(b-a)^2*u0^3; f0=p0/d0;h0=c0^(-1/2);g0=f0*h0;
gt0=-pi-phi0;gt(1)=g0;
for n=1:N
    fsum=d(n)*f0; hsum=-n/2*c(n)*h0;
    for j=1:n-1
        fsum=fsum+d(j)*f(n-j);hsum=hsum+(j/2-n)*c(j)*h(n-j);
    end
    f(n)=(p(n)-fsum)/d0; h(n)=hsum/n/c0;gsum=f0*h(n)+f(n)*h0;
    for j=1:n-1, gsum=gsum+f(j)*h(n-j);end; g(n)=gsum;
end;gt(2:end)=g(1:end-1)./(2:N);
for n=0:N; Asum=0;
    for m=n:N
        gtsum=(-1)^m*gt0/gamma(m+1)/gamma(-m+1/2);
        for j=0:m-1
            gtsum=gtsum+(-1)^j*gt(m-j)/gamma(j+1)/gamma(-j+1/2);
        end; Asum=Asum+gtsum*gamma(m+1)/gamma(m-n+1);
    end
    if n==0, A0=gamma(1/2)*Asum;else
        A(n)=gamma(1/2)/factorial(n)*Asum;end
end; PhiAsum=A0;
for j=1:N, PhiAsum=PhiAsum+A(j)*(y-1).^j; end
PhiA=phi0+sqrt(1-y).*PhiAsum;
end