clear; clc;
format long
u0=-2.14; %initial guess
u0v(1)=u0;
tol=1e-3; maxit=800;
m=1;
for N=8:2:20
    m=m+1;
    for it=1:maxit
        a0=u0;a(1)=0; a(2)=(u0+u0^2)/4;
        da0=1; da(1)=0; da(2)=(1+2*u0)/4;
        for n=1:N+1
            sum=a0*a(n); dsum=da0*a(n)+a0*da(n);
            for j=1:n
                if n==j
                    sum=sum+a0*a(j);
                    dsum=dsum+da(j)*a0+a(j)*da0;
                else
                    sum=sum+a(j)*a(n-j);
                    dsum=dsum+da(j)*a(n-j)+a(j)*da(n-j);
                end
            end
            a(n+2)=(a(n)+sum)/((n+2)^2);
            da(n+2)=(da(n)+dsum)/((n+2)^2);
        end
        A0=1; dA0=0;
        for n=1:N+1
            sum2=0; dsum2=0;
            for j=1:n
                if n==j
                    sum2=sum2+a(j)*A0;
                    dsum2=dsum2+da(j)*A0+a(j)*dA0;
                else
                    sum2=sum2+a(j)*A(n-j);
                    dsum2=dsum2+da(j)*A(n-j)+a(j)*dA(n-j);
                end
            end
            A(n)=-sum2/u0; dA(n)=-dsum2/u0+sum2/(u0^2);
        end
        u0=u0-A(N)/dA(N);
        if abs(A(N)/dA(N))<tol
            u0v(m)=u0;
            N
            it
            u0
            break
        end
    end
    if it==maxit
        disp('did not converge')
    end
end
