clear;clc;
Pc=1; rhoc=1; p=[rhoc; Pc];
delta=4.789; k=1; Tc=1.31; tol=1e-3;
B=[1 -3.25641527 2.571108893 2.86 0.6 -6]; %Lennard-Jones
maxit=100;m=0;
for N=2:length(B)
    m=m+1;
    for it=1:maxit
        sum1=0;dsum1=0;
        for j=0:N-1
            sum1=sum1+B(N-j)*(-1)^j*rhoc^(N-j)/gamma(j+1)/gamma(-j-delta+1);
            dsum1=dsum1+(N-j)*B(N-j)*(-1)^j*rhoc^(N-j-1)/gamma(j+1)/gamma(-j-delta+1);
        end; sum2=0; dsum2=0;
        for j=0:N-2
            sum2=sum2+B(N-1-j)*(-1)^j*rhoc^(N-j-1)/gamma(j+1)/gamma(-j-delta+1);
            dsum2=dsum2+(N-j-1)*B(N-1-j)*(-1)^j*rhoc^(N-j-2)/gamma(j+1)/gamma(-j-delta+1);
        end
        f0=Pc*(-1)^N-gamma(N+1)*gamma(-N-delta+1)*k*Tc*sum1;
        f1=Pc*(-1)^(N-1)-gamma(N)*gamma(-N-delta+2)*k*Tc*sum2;
        J=[-gamma(N+1)*gamma(-N-delta+1)*k*Tc*dsum1 (-1)^N;...
            -gamma(N)*gamma(-N-delta+2)*k*Tc*dsum2 (-1)^(N-1)]; resid=J\[f0;f1];
        p=p-resid;
        if abs(resid(1))<tol && abs(resid(2))<tol
            rhov(m)=p(1);
            Pcv(m)=p(2);
            itv(m)=it;
            break
        end
        rhoc=p(1); Pc=p(2);
    end
    if it==maxit
        disp('did not converge')
    end
end