% Predictions of C, G, and kappa for the Sakiadis Problem
clear;clc;
digits 24; format long
NN=50; A=ones(1,NN); C=vpa(sqrt(2),22); G=vpa(-sqrt(2),22); x=[C;G];
for n=1:NN
    Asum=0;for j=1:n, Asum=Asum+j^2*A(j)*A(n-j+1); end
    A(n+1)=Asum/n/(n+1)^2;
end; maxit=100; m=0; tol=1e-17;
for N=5:5:50
    m=m+1; nv=(0:N); Ac=[1 A(1:N)];
    for it=1:maxit
        J=[((1-nv).*G.^(nv)./C.^(nv))*Ac.' (nv.*G.^(nv-1).*C.^(1-nv))*Ac.';...
            -2/C^2+(nv.*(1-nv).*G.^nv./C.^(nv))*Ac.' (nv.^2.*G.^(nv-1).*C.^(1-nv))*Ac.'];
        phi0=(G.^nv.*C.^(1-nv))*Ac.'; phi1=2/C+(nv.*G.^nv.*C.^(1-nv))*Ac.';
        resid=J\[phi0;phi1];
        x=x-resid;
        if abs(resid(1))<tol && abs(resid(2))<tol
            vpa(x,17)
            Cv(m)=x(1) ;
            Gv(m)=x(2);
            itv(m)=it;
            break
        end
        C=x(1); G=x(2);
    end
    if it==maxit
        disp('did not converge')
    end
end
nv2=nv(3:end);
kappa=vpa(C^2/4*(G+(nv2.^2.*G.^nv2.*C.^(1-nv2))*A(2:end-1).'),17)