clear; clc; format long
% Shooting Method to determine kappa (and solve) the Sakiadis Problem
%parameters
L=20; deta=1e-4; eta=0:deta:L; tol=1e-15; maxit=100;
kappa=-0.4; %initial guess
for it=1:maxit %Newton iteration
    y=[0 1 kappa 0 0 1]; %initial conditions
    for n=1:length(eta)-1 %RK4
        k1=func(y) ; k2=func(y+k1*deta/2) ;
        k3=func(y+k2*deta/2) ; k4=func(y+k3*deta) ;
        y=y+(deta/6)*(k1+2*k2+2*k3+k4);
    end; u=y(2); U=y(5);
    kappa=kappa-u/U %Newton step
    if abs(u/U)<tol
        break
    end
end
if it==maxit
    disp('did not converge')
end
function RHS=func(y)
f=y(1); u=y(2); v=y(3); F=y(4); U=y(5); V=y(6);
RHS=[u v -v*f/2 U V -V*f/2-v*F/2];
end