function A=GaugeResum(a,g)
%% Computes a direct gauge resummation
%
%usage: a is a vector of coefficients in the original series
%starting with a(1). g(x) is the gauge function of the new series, to
%be input here as a string. The output A is the vector of coefficients
%of the new series. Note that the zeroth order coefficient
%of the original series is the same as that of the new series.
%
%example: In the resummation
%1+x+2*x^2+3*x^3+... =
%A0+A(1)*(1-exp(-x))+A(2)*(1-exp(-x))^2+A(3)(1-exp(-x))^3+...
% A0=1 and A(1:3) are given by A=GaugeResum([1 2 3],'1-exp(-x)')
N=length(a); A=a; syms y x; g=str2sym(g); x=solve(y-g,x);
check1=limit(x,y,0); check2=limit(x/y,y,0);
if check1~=0
    error('fails the requirement that x(g)=0 at g=0');
elseif check2==0
    error('fails the requirement that x(g)/g is nonzero at g=0')
else
end
%%choose below to avoid round off error
% gc=(fliplr(coeffs(taylor(x/y,y,'order',N+1),y,'ALL')));
%%choose below to speed up, but expect possible round-off error
gc=double(fliplr(coeffs(taylor(x/y,y,'order',N+1),y,'ALL')));
b0=gc(1); b=zeros(1,N); b(1:length(gc)-1)=gc(2:end);
for m=1:N
    C0=b0^m;
    for n=1:N
        Csum=n*m*b(n)*C0;
        for j=1:n-1
            Csum=Csum+(j*m-n+j)*b(j)*C(n-j,m);
        end
        C(n,m)=Csum/n/b0;
    end
end
for n=1:N
    asum=a(n)*b0^n;
    for m=1:n-1
        asum=asum+a(m)*C(n-m,m);
    end
    A(n)=asum;
end