function [A,B]=PadeApproximant(a0,a,N,M)
%Implements Pade (see chapter 4), note A0=a0 & B0=1
%Input 'a' as a row
if length(a)<(N+M)
    error('length of input vector must be at least N+M')
end
alph=zeros(M); A=zeros(1,N);
for i=1:M
    for j=1:M
        if (j-i)<N, alph(i,j)=a(N+i-j);
        elseif (j-i)==N, alph(i,j)=a0;
        else, alph(i,j)=0;
        end
    end
end; B=zeros(1,max(N,M));
avec=-a(N+1:N+M); Bvec=alph\avec.';
B(1:M)=Bvec;
for n=1:N
    asum=a(n)+B(n)*a0;
    for j=1:n-1, asum=asum+B(j)*a(n-j);end; A(n)=asum;
end
B=B(1:M);