function [b0,b]=SeriesShift(a0,a,x1,x2)
%given the series f=a0+...+a(N)*(x-x1)^N, this provides the expansion
%coefficients of f about x=x2: b0+...b(N)*(x-x2)^N
N=length(a); m=0:N; b=a;
for n=0:N
    sumvec=gamma(m+1)./gamma(m-n+1).*(x2-x1).^m.*[a0 a];
    if n==0
        b0=sum(sumvec);
    else
        b(n)=1/factorial(n)/(x2-x1)^n*sum(sumvec);
    end
end