function A=ShiftedDirichlet(a,lam)
%This provides A(1) through A(N) for a sum with gauge g=exp(lam*x)-1. (note, A0=a0)
N=length(a); A=zeros(1,N);
for n=1:N
    Asum=0;
    for m=1:n
        Asum=Asum+a(m)/lam^m*factorial(m)/factorial(n)*(-1)^(n-m)*stirling(n,m);
    end
    A(n)=Asum;
end
function f=stirling(n,k)
if k>n
    f=0;
elseif k==n
    f=1;
elseif k<n
    if k*n==0,f=0;
    else
        f=(n-1)*stirling(n-1,k)+stirling(n-1,k-1);
    end
end