function At=VandermondeApproximant(a0,a,mu,C,lambda)
%Provides the At(1:N) coefficients of Vandermonde approximant,
%given a0, a(1:N-1), mu(1:N), C, and lambda
N=length(mu);
if length(a)<(N-1)
    error('the length of ''a'' must be 1 less than that of mu')
end; a=a(1:N-1);
%Algorithm for inverting Vandermonde matrix from Turner (1966)
L=zeros(N);U=L; L(1,1)=1;
for i=1:N
    for j=1:N
        if j*i~=1 && i>=j
            prod=1;
            for k=1:i
                if j~=k, prod=prod/(mu(j)-mu(k));else, end
            end; L(i,j)=prod;
        else
        end
        if j==i
            U(i,j)=1;
        elseif j~=1
            if i==1
                U(i,j)=-U(i,j-1)*(mu(j-1));
            else
                U(i,j)=U(i-1,j-1)-U(i,j-1)*(mu(j-1));
            end
        end
    end
end
VMinv=(U*L).'; %inverse of the Vandermonde matrix
nv=0:(N-1);
b=factorial(nv).*[a0-C a].*lambda.^(-nv); %RHS in Vandermonde system
At=VMinv*b.';
end