function At=VandermondeDirichlet(a0,a,C,lambda)
%Provides the At(1:N) coefficients of Vandermonde approximant,
%given a0, a(1:N-1), C, and lambda
N=length(a)+1; A=zeros(1,N); At=A;
for n=1:N-1
    Asum=0;
    for m=1:n
        Asum=Asum+a(m)/lambda^m*factorial(m)/factorial(n)*(-1)^(n-m)*stirling(n,m);
    end
    A(n)=Asum;
end; A(N)=(-1)^N*(C-(-1).^(0:N-1)*[a0 A(1:N-1)].');
for n=1:N
    m=(n:N);
    At(n)=(-1)^n/factorial(n)*(A(n:N).*gamma(m+1)./gamma(m-n+1))*((-1).^m).';
end
function f=stirling(n,k)
if k>n, f=0; elseif k==n, f=1; elseif k<n
    if k*n==0,f=0;else, f=(n-1)*stirling(n-1,k)+stirling(n-1,k-1); end
end