function phi=getphi(phivals)
%% Example:
% n=0:20;
% phi=getphi([1 0 0 0])
%
% phi =
%
% cos(pi*n)/4 + cos((pi*n)/2)/2 + 1/4
%
% eval(phi)
%
% ans =
%
% [1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1]
N=length(phivals);
if round(N/2)==N/2
    delta=1; M=N/2-1;
else
    delta=0; M=(N-1)/2;
end
syms n; G=fft(phivals)/N;
phi=real(G(1))+delta*real(G(floor(N/2)+1))*cos(pi*n);
for m=1:M
    phi=phi+real(G(m+1)+G(N-m+1))*cos(2*pi*n*m/N)+...
        imag(G(N-m+1)-G(m+1))*sin(2*pi*n*m/N);
end