function theta=pendulum(t,E,s,N,M)
%pendulum(t,E) provides the angle of a simple pendulum with energy E
%at a time t away from top of the trajectory. E is positive and t is real.
%pendulum(t,E,s,N,M) allows one to specify either counterclockwise (s=1) or
%clockwise (s=-1) motion for rotation (E>2), N terms in the series solution
%(default is N=20), and M terms in computing the effective period (default is M=20);
if nargin==2,s=1;N=20;M=20;end;if nargin==3,N=20;M=20;end;if nargin==4,M=20;end
theta=nan(1,length(t)); %periodic extender (eqn 23 of Reinberger et al) given below
if E<2, Tstar=K(sqrt(E/2),M);
    theta0=acos(1-E); omega0=0; that=mod(t,4*Tstar);
    t1=mod(t(that>=0 & that<=Tstar),4*Tstar);
    t2=mod(t(that>=Tstar & that<=2*Tstar),4*Tstar);
    t3=mod(t(that>=2*Tstar & that<=3*Tstar),4*Tstar);
    t4=mod(t(that>=3*Tstar & that<=4*Tstar),4*Tstar);
    theta(that>=0 & that<=Tstar)=thetat(t1,theta0,omega0,N);
    theta(that>=Tstar & that<=2*Tstar)=...
        -thetat(2*Tstar-t2,theta0,omega0,N);
    theta(that>=2*Tstar & that<=3*Tstar)=...
        -thetat(t3-2*Tstar,theta0,omega0,N);
    theta(that>=3*Tstar & that<=4*Tstar)=...
        thetat(4*Tstar-t4,theta0,omega0,N);
elseif E>2, Tstar=sqrt(2/E)*K(sqrt(2/E),M); theta0=pi; omega0=s*sqrt(2*E-4);
    that=mod(t,2*Tstar); t1=t(that>=0 & that<=Tstar);
    t2=t(that>=Tstar & that<=2*Tstar);t1mod=mod(t1,2*Tstar);
    t2mod=mod(t2,2*Tstar);theta(that>=0 & that<=Tstar)=...
        thetat(t1mod,theta0,omega0,N)+...
        s*2*pi/(2*Tstar)*(t1-t1mod);
    theta(that>=Tstar & that<=2*Tstar)=s*2*pi/(2*Tstar)*(t2-t2mod)-...
        thetat(2*Tstar-t2mod,theta0,omega0,N)+2*pi+s*2*pi;
else, theta=-pi+4*atan(exp(t)); %eqn 6a of Reinberger et al
end
end
function f=thetat(t,theta0,omega0,N) %soln for t<Tstar
a0=theta0;s0=sin(theta0); c0=cos(theta0); a=nan(1,N);c=a;s=a;b=a;ahat=a;
a(1)=omega0; a(2)=-s0/2; s(1)=a(1)*c0; c(1)=-a(1)*s0;
for n=1:N-2, ssum=(n+1)*a(n+1)*c0; csum=(n+1)*a(n+1)*s0;
    for k=0:n-1
        ssum=ssum+(k+1)*a(k+1)*c(n-k); csum=csum+(k+1)*a(k+1)*s(n-k);
    end; s(n+1)=ssum/(n+1); c(n+1)=-csum/(n+1); a(n+2)=-s(n)/(n+1)/(n+2);
    b(n+2)=a(n+2);
end; f=a0; for n=1:N, f=f+a(n)*t.^n; end
end
function f=K(k,M) %eqn A4 of Reinberger et al
n=0:M;
f=(pi/2*(factorial(2*n)./(factorial(n)).^2).^2.*16.^(-n)-1./(2*n+1))*(k.^(2*n)).'+...
    log((1+k)/(1-k))/(2*k);
end