function [c0,c]=seriescos(a0,a)
%this provides the coefficients of the expansion (about x=0) of
%the cosine of the series a0+...a(N)*x^N
% % using the exponential of a series and Euler's identity
% [b0,b]=seriesexp(1i*a0,1i*a); c0=real(b0); c=real(b);
%self-contained
N=length(a); c0=cos(a0); c=a; c(1)=-a(1)*sin(a0);
for n=1:N-1
    jsum=0;
    for j=0:n-1
        ksum=(n-j)*a(n-j)*c0;
        for k=0:n-j-2
            ksum=ksum+(k+1)*a(k+1)*c(n-j-1-k);
        end
        jsum=jsum+(j+1)*a(j+1)/(n-j)*ksum;
    end
    c(n+1)=-a(n+1)*sin(a0)-jsum/(n+1);
end