function b=seriesinv(a)
% given the series y = a0 + a(1)*x + a(2)*x^2 + ... where a(1) is not 0
% this provides the coefficients of the inverse series
% x = b(1)*(y-a0) + b(2)*(y-a0)^2 + ...
N=length(a); b=nan(1,N); D=nan(N);
b(1)=1/a(1);
for n=1:N-1
    for m=1:N
        Dsum=0;
        for j=1:n-1
            Dsum=Dsum+(j*m+n-j)*a(j+1)*D(n-j,m);
        end
        D(n,m)=-m*a(n+1)/a(1)^(m+1)-Dsum/n/a(1);
    end
    b(n+1)=D(n,n+1)/(n+1);
end