function [b0,b]=seriespow(a0,a,g)
%this provides the coefficients of the expansion (about x=0)
%of (a0+...a(N)*x^N)^g
N=length(a);
if a0~=0
    b0=a0^g; b=a;
    for n=1:N
        sum=n*g*a(n)*b0;
        for j=1:n-1
            sum=sum+(j*g-n+j)*a(j)*b(n-j);
        end
        b(n)=sum/n/a0;
    end
else
    m=find(a,~0,'first'); b0=0; b(1:m*g-1)=0; b(m*g)=(a(m))^g;
    for n=m*g+1:N
        sum=0;
        for j=1:n-m*g
            sum=sum+(j*g-n+m*g+j)*a(j+m)*b(n-j);
        end
        b(n)=sum/(n-m*g)/a(m);
    end
end