function [s0,s]=seriessin(a0,a)
%this provides the coefficients of the expansion (about x=0) of
%the sine of the series a0+...a(N)*x^N
% % using the exponential of a series and Euler's identity
% [b0,b]=seriesexp(1i*a0,1i*a); s0=imag(b0); s=imag(b);
%self-contained
N=length(a); s0=sin(a0); s=a; s(1)=a(1)*cos(a0);
for n=1:N-1
    jsum=0;
    for j=0:n-1
        ksum=(n-j)*a(n-j)*s0;
        for k=0:n-j-2
            ksum=ksum+(k+1)*a(k+1)*s(n-j-1-k);
        end
        jsum=jsum+(j+1)*a(j+1)/(n-j)*ksum;
    end
    s(n+1)=a(n+1)*cos(a0)-jsum/(n+1);
end